package net.sf.aguacate.field;

import java.text.Format;
import java.text.ParseException;
import java.util.Date;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldTimeWithZone extends Field {

	private static final Logger LOGGER = LogManager.getLogger(FieldTimeWithZone.class);

	private final Format format;

	private final String minValue;

	private final String maxValue;

	public FieldTimeWithZone(String name, String type, boolean optional, Format format, String minValue,
			String maxValue) {
		super(name, type, optional);
		this.format = format;
		this.minValue = minValue;
		this.maxValue = maxValue;
	}

	public Format getFormat() {
		return format;
	}

	public String getMinValue() {
		return minValue;
	}

	public String getMaxValue() {
		return maxValue;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		if (value.getClass() == String.class) {
			try {
				String string = (String) value;
				Date date = (Date) format.parseObject(string);
				if (date == null) {
					return new ValidationConversionResult("Invalid format");
				} else {
					int ndx = FieldTimeUtil.timeZone(string);
					String tz = string.substring(ndx);
					String min = minValue.concat(tz);
					String max = maxValue.concat(tz);
					LOGGER.trace("{} & {} & {}", min, string, max);
					return FieldTimeUtil.validate((Date) format.parseObject(min), date, (Date) format.parseObject(max));
				}
			} catch (ParseException e) {
				return new ValidationConversionResult("Invalid format");
			}
		} else {
			return new ValidationConversionResult("Invalid value");
		}
	}

}
