package net.sf.aguacate.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.validator.ValidationConversionResult;

/**
 * <pre>
 * "field": {
 *   "type": "STRUCTURE_ARRAY",
 *   "data": {
 *     "innerField1": {
 *       "type": "INTEGER",
 *       "minval": ...,
 *       "maxval": ...
 *     },
 *     "innerField2": {
 *       "type" : "STRING",
 *       "minlen": ...,
 *       "maxlen": ...,
 *       "regex": ...
 *     }
 *   }
 * }
 * </pre>
 *
 */
public class FieldStructureArray extends Field {

	private final Field[] fields;

	public FieldStructureArray(String name, boolean optional, Map<String, Field> fields) {
		this(name, optional, fields.values());
	}

	public FieldStructureArray(String name, boolean optional, Collection<Field> fields) {
		this(name, optional, fields.toArray(new Field[fields.size()]));
	}

	public FieldStructureArray(String name, boolean optional, Field[] fields) {
		super(name, Field.STRUCTURE_ARRAY, optional);
		this.fields = fields;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		@SuppressWarnings("unchecked")
		List<Map<String, Object>> list = (List<Map<String, Object>>) value;
		List<Map<String, Object>> r = new ArrayList<>();
		int size = list.size();
		for (int i = 0; i < size; i++) {
			Map<String, Object> data = list.get(i);
			Map<String, Object> map = new HashMap<>();
			for (Field field : fields) {
				String fieldName = field.getName();
				Object obj = data.get(fieldName);
				if (field.isOptional()) {
					if (obj == null) {
						map.put(fieldName, null);
					} else {
						ValidationConversionResult result = field.validateAndConvert(obj);
						if (result.isSuccess()) {
							map.put(fieldName, result.getValue());
						} else {
							return result;
						}
					}
				} else {
					ValidationConversionResult result = field.validateAndConvert(obj);
					if (result.isSuccess()) {
						map.put(fieldName, result.getValue());
					} else {
						return result;
					}
				}
			}
			r.add(map);
		}
		return new ValidationConversionResult(r);
	}

}
