package net.sf.aguacate.field;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.sf.aguacate.validator.ValidationConversionResult;

/**
 * <pre>
 * "field": {
 *   "type": "STRUCTURE",
 *   "data": {
 *     "innerField1": {
 *       "type": "INTEGER",
 *       "minval": ...,
 *       "maxval": ...
 *     },
 *     "innerField2": {
 *       "type" : "STRING",
 *       "minlen": ...,
 *       "maxlen": ...,
 *       "regex": ...
 *     }
 *   }
 * }
 * </pre>
 *
 */
public class FieldStructure extends Field {

	private final Field[] fields;

	public FieldStructure(String name, boolean optional, Map<String, Field> fields) {
		this(name, optional, fields.values());
	}

	public FieldStructure(String name, boolean optional, Collection<Field> fields) {
		this(name, optional, fields.toArray(new Field[fields.size()]));
	}

	public FieldStructure(String name, boolean optional, Field[] fields) {
		super(name, Field.STRUCTURE_ARRAY, optional);
		this.fields = fields;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		@SuppressWarnings("unchecked")
		Map<String, Object> data = (Map<String, Object>) value;
		Map<String, Object> map = new HashMap<>();
		for (Field field : fields) {
			String fieldName = field.getName();
			Object obj = data.get(fieldName);
			if (field.isOptional()) {
				if (obj == null) {
					map.put(fieldName, null);
				} else {
					ValidationConversionResult result = field.validateAndConvert(obj);
					if (result.isSuccess()) {
						map.put(fieldName, result.getValue());
					} else {
						return result;
					}
				}
			} else {
				ValidationConversionResult result = field.validateAndConvert(obj);
				if (result.isSuccess()) {
					map.put(fieldName, result.getValue());
				} else {
					return result;
				}
			}
		}
		return new ValidationConversionResult(map);
	}

}
