package net.sf.aguacate.field;

import net.sf.aguacate.validator.ValidationConversionResult;

public abstract class FieldNumber extends Field {

	public FieldNumber(String name, String type, boolean optional) {
		super(name, type, optional);
	}

	<T extends Number & Comparable<T>> ValidationConversionResult validate(T min, T val, T max) {
		if (val.compareTo(min) < 0) {
			return new ValidationConversionResult("Invalid minimum value");
		} else {
			if (val.compareTo(max) > 0) {
				return new ValidationConversionResult("Invalid maximum value");
			} else {
				return new ValidationConversionResult(val);
			}
		}
	}

}
