package net.sf.aguacate.context.spi.sql.impl;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;

public class SentenceSqlStaticInsertWithId extends AbstractSentenceSql {

	private final String sql;

	private final Parameter[] required;

	private final Parameter[] optional;

	private final String[] columns;

	public SentenceSqlStaticInsertWithId(String name, String message, String sql, List<String> methods,
			Collection<Parameter> required, Collection<Parameter> optional, String column) {
		super(name, message, methods);
		this.sql = sql;
		this.required = Prm.toArray(required);
		this.optional = Prm.toArray(optional);
		this.columns = new String[] { column };
	}

	@Override
	public FunctionEvalResult evaluate0(FunctionContext functionContext, Map<String, Object> context)
			throws SQLException {
		BigInteger id = functionContext.databaseInterface().executeSqlInsertWithId(functionContext.acquireConnection(),
				sql, context, required, optional, columns);
		if (id == null) {
			return FAILURE;
		} else {
			return new FunctionEvalResult(true, id);
		}
	}

}
