package net.sf.aguacate.context.spi.sql.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;

public class SentenceSqlStaticInsert extends AbstractSentenceSql {

	private static final Logger LOGGER = LogManager.getLogger(SentenceSqlStaticInsert.class);

	private final String sql;

	private final Parameter[] required;

	private final Parameter[] optional;

	public SentenceSqlStaticInsert(String name, String message, String sql, List<String> methods,
			List<Parameter> required, List<Parameter> optional) {
		super(name, message, methods);
		this.sql = sql;
		this.required = Prm.toArray(required);
		this.optional = Prm.toArray(optional);
	}

	@Override
	public FunctionEvalResult evaluate0(FunctionContext functionContext, Map<String, Object> context)
			throws SQLException {
		int count = functionContext.databaseInterface().executeSqlInsert(functionContext.acquireConnection(), sql,
				context, required, optional);
		if (LOGGER.isInfoEnabled()) {
			LOGGER.debug("inserted: {}", count);
		}
		if (count == 1) {
			return SUCCESS;
		} else {
			return FAILURE;
		}
	}

}
