package net.sf.aguacate.context.spi.sql.impl;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;
import net.sf.aguacate.util.type.Str;

public class SentenceSqlInsertWithId extends AbstractSentenceSql {

	private static final Logger LOGGER = LogManager.getLogger(SentenceSqlInsertWithId.class);

	private final String table;

	private final Parameter[] required;

	private final Parameter[] optional;

	private final String[] outputContext;

	private final String outputName;

	private final String[] columns;

	public SentenceSqlInsertWithId(String name, String message, String table, List<String> methods,
			List<Parameter> required, List<Parameter> optional, List<String> outputContext, String outputName,
			String column) {
		super(name, message, methods);
		this.table = table;
		this.required = Prm.toArray(required);
		this.optional = Prm.toArray(optional);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
		this.columns = new String[] { column };
	}

	@Override
	public FunctionEvalResult evaluate0(FunctionContext functionContext, Map<String, Object> context)
			throws SQLException {
		BigInteger id = functionContext.databaseInterface().executeInsertWithId(functionContext.acquireConnection(),
				table, context, required, optional, columns);
		LOGGER.debug("id: {}", id);
		return new FunctionEvalResult(true, id);
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

}
