package net.sf.aguacate.configuration.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import net.sf.aguacate.configuration.Configuration;
import net.sf.aguacate.context.ContextProcessor;
import net.sf.aguacate.context.ContextValidator;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.field.format.FieldFormat;
import net.sf.aguacate.util.type.Str;
import net.sf.aguacate.validator.InputValidator;
import net.sf.aguacate.validator.impl.InputValidatorImpl;

public class ConfigurationImpl implements Configuration {

	private final String datasource;

	private final Map<String, InputValidator> validatorConverters;

	// TODO: Convert to Map<String, List<Object[]> or something like
	private final Map<String, Map<String, FieldFormat>> outputFields;

	private final ContextValidator contextValidator;

	private final ContextProcessor contextProcessor;

	private final String[] methods;

	public ConfigurationImpl(String primary, String datasource, Map<String, Map<String, Field>> inputFields,
			Map<String, Map<String, FieldFormat>> outputFields, ContextValidator contextValidator,
			ContextProcessor contextProcessor) {
		Map<String, InputValidator> temp = new HashMap<>();
		for (Map.Entry<String, Map<String, Field>> entry : inputFields.entrySet()) {
			Map<String, Field> fields = entry.getValue();
			temp.put(entry.getKey(), new InputValidatorImpl(fields.remove(primary), fields));
		}
		this.datasource = datasource;
		this.validatorConverters = temp;
		this.outputFields = outputFields;
		this.contextValidator = contextValidator;
		this.contextProcessor = contextProcessor;

		Set<String> methods1 = validatorConverters.keySet();
		Set<String> methods2 = outputFields.keySet();
		if (methods1 == null) {
			if (methods2 == null) {
				methods = new String[0];
			} else {
				methods = Str.toArray(methods2);
			}
		} else {
			if (methods2 == null) {
				methods = Str.toArray(methods1);
			} else {
				Set<String> set = new TreeSet<>(methods1);
				set.addAll(methods2);
				methods = Str.toArray(set);
			}
		}
		Arrays.sort(methods);
	}

	@Override
	public String getDatasource() {
		return datasource;
	}

	@Override
	public InputValidator getValidatorConverter(String method) {
		return validatorConverters.get(method);
	}

	@Override
	public boolean accepts(String method) {
		return Arrays.binarySearch(methods, method) >= 0;
	}

	@Override
	public Map<String, FieldFormat> getOutputFields(String method) {
		return outputFields.get(method);
	}

	@Override
	public ContextValidator getContextValidator() {
		return contextValidator;
	}

	@Override
	public ContextProcessor getContextProcessor() {
		return contextProcessor;
	}

	@Override
	public String[] methods() {
		return methods;
	}

}
