package net.sf.aguacate.util.type;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Num {

	private Num() {
	}

	public static boolean isZero(Number number) {
		if (null == number) {
			return false;
		} else {
			Class<?> klass = number.getClass();
			if (Long.class == klass) {
				return Long.valueOf(0).equals(number);
			} else {
				if (Integer.class == klass) {
					return Integer.valueOf(0).equals(number);
				} else {
					if (BigInteger.class == klass) {
						return BigInteger.ZERO.equals(number);
					} else {
						if (BigDecimal.class == klass) {
							BigDecimal temp = (BigDecimal) number;
							return BigDecimal.valueOf(0, temp.scale()).equals(temp);
						} else {
							if (Short.class == klass) {
								return Short.valueOf((short) 0).equals(number);
							} else {
								if (Byte.class == klass) {
									return Byte.valueOf((byte) 0).equals(number);
								} else {
									throw new IllegalStateException("Type not supported exception: " + klass.getName());
								}
							}
						}
					}
				}
			}
		}
	}

	public int toInt(Object value) {
		Class<?> klass = value.getClass();
		if (String.class == klass) {
			return Integer.parseInt((String) value);
		} else {
			if (Integer.class == klass || Short.class == klass || Byte.class == klass) {
				return ((Number) value).intValue();
			} else {
				if (Long.class == klass) {
					Long n = ((Long) value);
					if (Integer.MAX_VALUE >= n.longValue()) {
						return n.intValue();
					} else {
						throw new IllegalArgumentException(value + " greather than " + Integer.MAX_VALUE);
					}
				} else {
					if (BigInteger.class == klass) {
						BigInteger n = ((BigInteger) value);
						if (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(n) >= 0) {
							return n.intValue();
						} else {
							throw new IllegalArgumentException(value + " greather than " + Integer.MAX_VALUE);
						}
					} else {
						throw new IllegalArgumentException(klass.getName());
					}
				}
			}
		}
	}

}
