package net.sf.aguacate.util.servlet;

import java.util.Iterator;
import java.util.ServiceLoader;

import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServletUtil {

	private static final Logger LOGGER = LogManager.getFormatterLogger(ServletUtil.class);

	public static final String REQ_METADATA;

	private static final PathInfo INSTANCE;

	static {
		final String defaultClassName = "net.sf.aguacate.util.servlet.PathInfoImpl";
		REQ_METADATA = "metadata";
		PathInfo instance;
		Iterator<PathInfo> iterator = ServiceLoader.load(PathInfo.class).iterator();
		if (iterator.hasNext()) {
			instance = iterator.next();
			if (LOGGER.isInfoEnabled()) {
				LOGGER.info("Use class: {}", instance.getClass().getName());
			}
			if (iterator.hasNext()) {
				LOGGER.warn("Multiple instances of {}: {}", PathInfo.class.getName(),
						iterator.next().getClass().getName());
			}
			try {
				// test
				assert Class.forName(defaultClassName) != null;
			} catch (ClassNotFoundException e) {
				throw new IllegalStateException(e);
			}
		} else {
			try {
				LOGGER.info("load default class: " + defaultClassName);
				instance = (PathInfo) Class.forName(defaultClassName).newInstance();
			} catch (ReflectiveOperationException e) {
				throw new IllegalStateException(e);
			}
		}
		INSTANCE = instance;
	}

	static {
	}

	public static String getEntity(HttpServletRequest request) {
		return INSTANCE.getEntity(request);
	}

	public static String getId(HttpServletRequest request) {
		return INSTANCE.getId(request);
	}

}
