package net.sf.aguacate.util.parameter;

import java.util.List;
import java.util.Map;

import net.sf.aguacate.util.type.Str;

public class Parameter {

	private final String[] context;

	private final String name;

	private final String aliasOf;

	private final String from;

	public Parameter(String name) {
		this((List<String>) null, name, null, null);
	}

	public Parameter(List<String> context, String name, String aliasOf, String from) {
		this(Str.toArray(context), name, aliasOf, from);
	}

	private Parameter(String[] context, String name, String aliasOf, String from) {
		this.context = context;
		this.name = name;
		if (aliasOf == null) {
			this.aliasOf = name;
		} else {
			this.aliasOf = aliasOf;
		}
		this.from = from;
	}

	public String getName() {
		return name;
	}

	public String getAliasOf() {
		return aliasOf;
	}

	// TODO: remove
	public String getFrom() {
		return from;
	}

	public Map<String, Object> calculateContext(Map<String, Object> initial) {
		if (context.length == 0) {
			return initial;
		} else {
			Map<String, Object> ctx = initial;
			for (String current : context) {
				@SuppressWarnings("unchecked")
				Map<String, Object> temp = (Map<String, Object>) ctx.get(current);
				ctx = temp;
			}
			return ctx;
		}
	}

}
