package net.sf.aguacate.util.dynamic.bridge.spi;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.util.codec.bridge.CodecCoupling;

final class ScriptUtil {

	private static final Logger LOGGER = LogManager.getLogger(ScriptUtil.class);

	private ScriptUtil() {
	}

	@SuppressWarnings("unchecked")
	static <T> T unwrap(ScriptEngine engine, Invocable invocable, Bindings bindings, Object value)
			throws NoSuchMethodException, ScriptException, IOException {
		if (value != null && "jdk.nashorn.api.scripting.ScriptObjectMirror".equals(value.getClass().getName())) {
			String string = convert(engine, invocable, bindings, value);
			switch (string.charAt(0)) {
			case '{':
				value = CodecCoupling.jsonCodecBridge().decodeMap(string);
				break;
			case '[':
				value = CodecCoupling.jsonCodecBridge().decodeList(string);
				break;
			default:
				throw new IllegalStateException(string);
			}
		}
		return (T) value;
	}

	static Map<String, Object> unwrapMap(ScriptEngine engine, Invocable invocable, Bindings bindings, Object value)
			throws NoSuchMethodException, ScriptException, IOException {
		if (value == null) {
			return null;
		} else {
			String name = value.getClass().getName();
			if ("jdk.nashorn.api.scripting.ScriptObjectMirror".equals(name)) {
				String string = convert(engine, invocable, bindings, value);
				if ('{' == string.charAt(0)) {
					return CodecCoupling.jsonCodecBridge().decodeMap(string);
				} else {
					throw new IllegalStateException(string);
				}
			} else {
				throw new IllegalArgumentException(name);
			}
		}
	}

	static List<Object> unwrapList(ScriptEngine engine, Invocable invocable, Bindings bindings, Object value)
			throws NoSuchMethodException, ScriptException, IOException {
		if (value == null) {
			return null;
		} else {
			String name = value.getClass().getName();
			if ("jdk.nashorn.api.scripting.ScriptObjectMirror".equals(name)) {
				String string = convert(engine, invocable, bindings, value);
				if ('[' == string.charAt(0)) {
					return CodecCoupling.jsonCodecBridge().decodeList(string);
				} else {
					throw new IllegalStateException(string);
				}
			} else {
				throw new IllegalArgumentException(name);
			}
		}
	}

	private static String convert(ScriptEngine engine, Invocable invocable, Bindings bindings, Object value)
			throws ScriptException, NoSuchMethodException {
		LOGGER.trace("extracting JS object {}", value);
		String string = (String) invocable.invokeMethod(engine.eval("JSON", bindings), "stringify", value);
		LOGGER.debug("extracting JS object {}", string);
		return string;
	}

}
