package net.sf.aguacate.util.config.database.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.sql.DataSource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;

import net.sf.aguacate.util.config.database.DatabaseBridge;
import net.sf.aguacate.util.config.database.DatabaseInterface;

public class DatabaseBridgeBuilderHikari implements DatabaseBridgeBuilder {

	private static final Map<String, DatabaseInterface> INTERFACES;

	static {
		Map<String, DatabaseInterface> interfaces = new HashMap<>();
		interfaces.put("mysql", new DatabaseInterfaceMysql());
		interfaces.put("hsqldb", new DatabaseInterfaceHsqldb());
		INTERFACES = interfaces;
	}

	@Override
	public DatabaseBridge build(Map<String, Object> configuration) {
		String vendor = (String) configuration.get("vendor");
		DatabaseInterface databaseInterface = INTERFACES.get(vendor);
		if (databaseInterface == null) {
			// Avoid use of null literal
			throw new IllegalArgumentException(String.valueOf(vendor));
		} else {
			return new DatabaseBridge(databaseInterface, datasource(configuration));
		}
	}

	@SuppressWarnings("unchecked")
	private DataSource datasource(Map<String, Object> configuration) {
		Properties properties = new Properties();
		properties.putAll((Map<String, String>) configuration.get("properties"));
		HikariDataSource ds = new HikariDataSource(new HikariConfig(properties));
		return ds;
	}

}
