/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.type;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Num {
    private Num() {
    }

    public static boolean isZero(Number number) {
        if (null == number) {
            return false;
        }
        Class<?> klass = number.getClass();
        if (Long.class == klass) {
            return Long.valueOf(0L).equals(number);
        }
        if (Integer.class == klass) {
            return Integer.valueOf(0).equals(number);
        }
        if (BigInteger.class == klass) {
            return BigInteger.ZERO.equals(number);
        }
        if (BigDecimal.class == klass) {
            BigDecimal temp = (BigDecimal)number;
            return BigDecimal.valueOf(0L, temp.scale()).equals(temp);
        }
        if (Short.class == klass) {
            return Short.valueOf((short)0).equals(number);
        }
        if (Byte.class == klass) {
            return Byte.valueOf((byte)0).equals(number);
        }
        throw new IllegalStateException("Type not supported exception: " + klass.getName());
    }

    public int toInt(Object value) {
        Class<?> klass = value.getClass();
        if (String.class == klass) {
            return Integer.parseInt((String)value);
        }
        if (Integer.class == klass || Short.class == klass || Byte.class == klass) {
            return ((Number)value).intValue();
        }
        if (Long.class == klass) {
            Long n = (Long)value;
            if (Integer.MAX_VALUE >= n) {
                return n.intValue();
            }
            throw new IllegalArgumentException(value + " greather than " + Integer.MAX_VALUE);
        }
        if (BigInteger.class == klass) {
            BigInteger n = (BigInteger)value;
            if (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(n) >= 0) {
                return n.intValue();
            }
            throw new IllegalArgumentException(value + " greather than " + Integer.MAX_VALUE);
        }
        throw new IllegalArgumentException(klass.getName());
    }
}

