/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database.spi;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.aguacate.util.config.database.DatabaseBridge;
import net.sf.aguacate.util.config.database.DatabaseInterface;
import net.sf.aguacate.util.config.database.spi.DatabaseBridgeBuilder;
import net.sf.aguacate.util.config.database.spi.DatabaseInterfaceHsqldb;
import net.sf.aguacate.util.config.database.spi.DatabaseInterfaceMysql;

public class DatabaseBridgeBuilderHikari
implements DatabaseBridgeBuilder {
    private static final Map<String, DatabaseInterface> INTERFACES;

    @Override
    public DatabaseBridge build(Map<String, Object> configuration) {
        String vendor = (String)configuration.get("vendor");
        DatabaseInterface databaseInterface = INTERFACES.get(vendor);
        if (databaseInterface == null) {
            throw new IllegalArgumentException(String.valueOf(vendor));
        }
        return new DatabaseBridge(databaseInterface, this.datasource(configuration));
    }

    private DataSource datasource(Map<String, Object> configuration) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)((Map)configuration.get("properties")));
        HikariDataSource ds = new HikariDataSource(new HikariConfig(properties));
        return ds;
    }

    static {
        HashMap<String, DatabaseInterface> interfaces = new HashMap<String, DatabaseInterface>();
        interfaces.put("mysql", new DatabaseInterfaceMysql());
        interfaces.put("hsqldb", new DatabaseInterfaceHsqldb());
        INTERFACES = interfaces;
    }
}

