package net.sf.aguacate.util.type;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Param {

	private Param() {
	}

	@SuppressWarnings("unchecked")
	public static Map<String, String> toParams(Object object) {
		if (object == null) {
			return Collections.emptyMap();
		} else {
			if (object instanceof List) {
				// [ "a", "b" ] || [ { "a" : "A" }, "b" ] || [ { "a" : "A" }, { "b", "B" } ]
				List<Object> list = (List<Object>) object;
				Map<String, String> map = new LinkedHashMap<>();
				for (int i = 0; i < list.size(); i++) {
					Object current = list.get(i);
					if (current instanceof Map) {
						Map<String, String> inner = (Map<String, String>) current;
						if (inner.size() > 1) {
							// error
						} else {
							// size == 1
							map.putAll(inner);
						}
					} else {
						if (String.class == current.getClass()) {
							String str = (String) current;
							map.put(str, str);
						} else {
							// error
						}
					}
				}
				return map;
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					// "a"
					String str = (String) object;
					return Collections.singletonMap(str, str);
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

}
