package net.sf.aguacate.util.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.util.type.Str;

public final class Prm {

	private static final Parameter[] EMPTY = new Parameter[0];

	private Prm() {
	}

	@SuppressWarnings("unchecked")
	public static List<Parameter> toList(Object object) {
		if (object == null) {
			return Collections.emptyList();
		} else {
			if (object instanceof List) {
				List<Object> original = (List<Object>) object;
				int size = original.size();
				List<Parameter> result = new ArrayList<>(size);
				for (int i = 0; i < size; i++) {
					Object current = original.get(i);
					result.add(toParameter(current));
				}
				return result;
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					return Collections.singletonList(toParameter(object));
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

	public static Parameter[] toArray(Collection<Parameter> list) {
		if (list == null || list.isEmpty()) {
			return EMPTY;
		} else {
			return list.toArray(new Parameter[list.size()]);
		}
	}

	@SuppressWarnings("unchecked")
	public static Parameter toParameter(Object object) {
		if (object == null) {
			return null;
		} else {
			if (object instanceof Map) {
				Map<String, Object> map = (Map<String, Object>) object;
				return new Parameter(Str.toList(map.get("context")), (String) map.get("name"),
						(String) map.get("aliasOf"), (String) map.get("from"));
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					return new Parameter((String) object);
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

}
