package net.sf.aguacate.util.filesystem;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.util.filesystem.spi.WatchdogRunner;

public final class FileSystemObserver {

	private static final Logger LOGGER = LogManager.getLogger(FileSystemObserver.class);

	private static Collection<WatchdogRunner> runners;

	static {
		runners = Collections.emptyList();
	}

	private FileSystemObserver() {
	}

	public static void watch(Path directory, EventHandler handler) {
		WatchdogRunner runner = new WatchdogRunner(directory, handler);
		synchronized (FileSystemObserver.class) {
			LOGGER.info("{} handled by {}", directory, handler);
			Collection<WatchdogRunner> temp = new ArrayList<>(runners);
			temp.add(runner);
			LOGGER.trace(temp);
			runners = temp;
		}
		new Thread(runner).start();
	}

}
