package net.sf.aguacate.util.type;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Arr {

	private static Map<Class<?>, Object> instances;

	static {
		instances = Collections.emptyMap();
	}

	private Arr() {
	}

	@SuppressWarnings("unchecked")
	public static <T> T[] toArray(Class<T> klass, Collection<T> list) {
		if (list == null || list.isEmpty()) {
			Object instance = instances.get(klass);
			if (instance == null) {
				synchronized (Arr.class) {
					instance = instances.get(klass);
					if (instance == null) {
						instance = Array.newInstance(klass, 0);
						Map<Class<?>, Object> temp = new HashMap<>(instances);
						temp.put(klass, instance);
						instances = temp;
					}
				}
			}
			return (T[]) instance;
		} else {
			return list.toArray((T[]) Array.newInstance(klass, list.size()));
		}
	}

}
