package net.sf.aguacate.util.dynamic.bridge.spi;

import java.io.Reader;

import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

import net.sf.aguacate.util.dynamic.bridge.DynamicFactory;

public class DynamicFactoryScript implements DynamicFactory {

	private final ScriptEngine engine;

	private final Compilable compilable;

	private final Invocable invocable;

	public DynamicFactoryScript(ScriptEngine engine) {
		this.engine = engine;
		if (engine instanceof Compilable) {
			compilable = (Compilable) engine;
		} else {
			throw new IllegalStateException("No Compilable instance ".concat(engine.getClass().getName()));
		}
		if (engine instanceof Invocable) {
			invocable = (Invocable) engine;
		} else {
			throw new IllegalStateException("No Invocable instance ".concat(engine.getClass().getName()));
		}
	}

	@Override
	public DynamicScript createFrom(Reader reader) {
		try {
			return create(compilable.compile(reader));
		} catch (ScriptException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public DynamicScript createString(String source) {
		try {
			return create(compilable.compile(source));
		} catch (ScriptException e) {
			throw new IllegalStateException(e);
		}
	}

	DynamicScript create(CompiledScript compiled) {
		return new DynamicScript(engine, invocable, compiled);
	}

	public ScriptEngine getEngine() {
		return engine;
	}

}
