package net.sf.aguacate.util.codec.bridge;

import net.sf.aguacate.util.codec.bridge.spi.CodecBridgeObjectMapperJson;

public class CodecCoupling {

	private static final CodecBridge JSON_INSTANCE;

	private static CodecBridge YAML_INSTANCE;

	static {
		JSON_INSTANCE = new CodecBridgeObjectMapperJson();
	}

	public static CodecBridge jsonCodecBridge() {
		return JSON_INSTANCE;
	}

	public static CodecBridge yamlCodecBridge() {
		if (YAML_INSTANCE == null) {
			synchronized (CodecCoupling.class) {
				if (YAML_INSTANCE == null) {
					try {
						YAML_INSTANCE = (CodecBridge) Class
								.forName("net.sf.aguacate.util.codec.bridge.spi.CodecBridgeObjectMapperYaml")
								.newInstance();
					} catch (ReflectiveOperationException e) {
						throw new IllegalArgumentException(e);
					}
				}
			}
		}
		return YAML_INSTANCE;
	}

}
