/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.meta.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import net.sf.aguacate.util.meta.Meta;
import net.sf.aguacate.util.meta.MetaBuilder;
import net.sf.aguacate.util.meta.maven.MetaMaven;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaBuilderMaven
implements MetaBuilder {
    private static final Logger LOGGER = LogManager.getLogger(MetaBuilderMaven.class);
    private static final String BASE = "/META-INF/maven/";

    @Override
    public Meta build(Class<?> klass, String group, String artifact) {
        String name = BASE + group + '/' + artifact + '/' + "pom.properties";
        LOGGER.debug(name);
        InputStream inputStream = klass.getResourceAsStream(name);
        if (inputStream == null) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String version = properties.getProperty("version");
            LOGGER.debug("version ({} & {}): {}", (Object)group, (Object)artifact, (Object)version);
            MetaMaven metaMaven = new MetaMaven(version);
            return metaMaven;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("On close inputStream", (Throwable)e);
            }
        }
    }
}

