package net.sf.aguacate.util.type;

import java.util.Collections;
import java.util.List;

public class Str {

	private Str() {
	}

	@SuppressWarnings("unchecked")
	public static List<String> stringOrString(Object object) {
		if (object == null) {
			return Collections.emptyList();
		} else {
			if (object instanceof List) {
				return (List<String>) object;
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					return Collections.singletonList((String) object);
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

}
