package net.sf.aguacate.util.servlet;

import javax.servlet.http.HttpServletRequest;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathInfoImpl implements PathInfo {

	private static final Logger LOGGER = LogManager.getLogger(PathInfoImpl.class);

	@Override
	public String getEntity(HttpServletRequest request) {
		String servletPath = request.getServletPath();
		LOGGER.trace(servletPath);
		return getEntity(servletPath);
	}

	String getEntity(String servletPath) {
		if (servletPath.charAt(0) == '/') {
			String result;
			int ndx = servletPath.indexOf('/', 1);
			if (ndx < 0) {
				result = servletPath.substring(1);
			} else {
				result = servletPath.substring(1, ndx);
			}
			LOGGER.trace(result);
			return result;
		} else {
			throw new IllegalArgumentException();
		}
	}

	@Override
	public String getId(HttpServletRequest request) {
		String servletPath = request.getServletPath();
		LOGGER.trace(servletPath);
		return getId(servletPath);
	}

	String getId(String servletPath) {
		if (servletPath == null) {
			return null;
		} else {
			String result;
			int ndx = servletPath.indexOf('/', 1);
			if (ndx < 0) {
				result = null;
			} else {
				result = servletPath.substring(ndx + 1);
			}
			LOGGER.trace(result);
			return result;
		}
	}

}
