/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.filesystem.spi;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import net.sf.aguacate.util.filesystem.EventHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WatchdogRunner
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(WatchdogRunner.class);
    private final Path directory;
    private final EventHandler handler;
    private boolean running;
    private Thread thread;
    private static final WatchEvent.Kind<?>[] EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};

    public WatchdogRunner(Path directory, EventHandler handler) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(directory.toString());
        }
        this.directory = directory;
        this.handler = handler;
        this.running = true;
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        assert (this.thread != null);
        try {
            WatchService watcher = this.directory.getFileSystem().newWatchService();
            this.directory.register(watcher, EVENTS);
            LOGGER.info("Alive {} for {}: {}", (Object)Thread.currentThread().getName(), (Object)this.directory, (Object)this.running);
            assert (this.running);
            while (this.running) {
                try {
                    LOGGER.info("Waiting for {} ...", (Object)this.directory);
                    WatchKey key = watcher.take();
                    LOGGER.debug("Events for {}", (Object)this.directory);
                    List<WatchEvent<?>> events = key.pollEvents();
                    int size = events.size();
                    for (int i = 0; i < size; ++i) {
                        Path child;
                        LOGGER.debug("Change on: {}", (Object)this.directory);
                        WatchEvent<?> event = events.get(i);
                        WatchEvent.Kind<?> kind = event.kind();
                        if (StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
                            child = (Path)event.context();
                            LOGGER.trace("updated: {} ({})", (Object)child, (Object)this.directory);
                            this.handler.onUpdate(this.directory, child);
                            continue;
                        }
                        if (!StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) continue;
                        child = (Path)event.context();
                        LOGGER.trace("deleted: {} ({})", (Object)child, (Object)this.directory);
                        this.handler.onDelete(this.directory, child);
                    }
                    key.reset();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Forced Wakeup");
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("On check directory", (Throwable)e);
        }
    }

    void shutdown() {
        LOGGER.warn("stopping ... {}", (Object)Thread.currentThread().getName());
        this.running = false;
        this.thread.interrupt();
    }
}

