/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.util.config.database.DatabaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDatabaseInterface
implements DatabaseInterface {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDatabaseInterface.class);
    private static final Logger MESSAGE_LOGGER = LogManager.getLogger((String)"aguacate.sentence");
    private static final String STR_AND = " AND ";
    private static final int STR_AND_LENGTH = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> executeSqlSelectSingleRow(String name, String message, Connection connection, String sql, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            String msg;
            block21: {
                Map<String, Object> map;
                Object[] arguments = this.setSelectParameters(context, required, statement);
                msg = MessageFormat.format(message, arguments);
                resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) break block21;
                    Map<String, Object> map2 = this.extract(optional, resultSet);
                    if (resultSet.next()) {
                        LOGGER.warn("Multiple results");
                    }
                    this.logSuccess(name, msg);
                    map = map2;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("On close resultSet", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("On close resultSet", (Throwable)e);
                }
                return map;
            }
            this.logFailure(name, msg);
            Map<String, Object> map = null;
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close resultSet", (Throwable)e);
            }
            return map;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> executeSqlSelectMultipleRow(String name, String message, Connection connection, String sql, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            String msg;
            block27: {
                Map<String, Object> first;
                block28: {
                    ArrayList<Map<String, Object>> arrayList;
                    Object[] arguments = this.setSelectParameters(context, required, statement);
                    msg = MessageFormat.format(message, arguments);
                    resultSet = statement.executeQuery();
                    try {
                        if (!resultSet.next()) break block27;
                        first = this.extract(optional, resultSet);
                        if (!resultSet.next()) break block28;
                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                        list.add(first);
                        do {
                            list.add(this.extract(optional, resultSet));
                        } while (resultSet.next());
                        this.logSuccess(name, msg);
                        arrayList = list;
                    }
                    catch (Throwable throwable) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("On close resultSet", (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("On close resultSet", (Throwable)e);
                    }
                    return arrayList;
                }
                this.logSuccess(name, msg);
                List<Map<String, Object>> list = Collections.singletonList(first);
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("On close resultSet", (Throwable)e);
                }
                return list;
            }
            this.logFailure(name, msg);
            List<Map<String, Object>> list = null;
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close resultSet", (Throwable)e);
            }
            return list;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeSqlSelectValue(String name, String message, Connection connection, String sql, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            String msg;
            block21: {
                Object object;
                Object[] arguments = this.setSelectParameters(context, required, statement);
                msg = MessageFormat.format(message, arguments);
                resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) break block21;
                    Object value = resultSet.getObject(1);
                    if (resultSet.next()) {
                        LOGGER.warn("Multiple rows");
                    }
                    this.logSuccess(name, msg);
                    object = value;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("On close resultSet", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("On close resultSet", (Throwable)e);
                }
                return object;
            }
            this.logFailure(name, msg);
            Object var12_13 = null;
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close resultSet", (Throwable)e);
            }
            return var12_13;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSqlUpdate(Connection connection, String sql, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            int position = 1;
            for (String parameter : optional) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            for (String parameter : required) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeSqlInsert(Connection connection, String sql, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            int position = 1;
            for (String parameter : required) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            for (String parameter : optional) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> executeSelectSingleRow(String name, String message, Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildSelectSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        return this.executeSqlSelectSingleRow(name, message, connection, sql, context, required, optional);
    }

    @Override
    public List<Map<String, Object>> executeSelectMultipleRow(String name, String message, Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildSelectSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        return this.executeSqlSelectMultipleRow(name, message, connection, sql, context, required, optional);
    }

    @Override
    public Object executeSelectValue(String name, String message, Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildSelectSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        return this.executeSqlSelectValue(name, message, connection, sql, context, required, optional);
    }

    @Override
    public int executeUpdate(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildUpdateSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        return this.executeSqlUpdate(connection, sql, context, required, optional);
    }

    @Override
    public int executeInsert(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildInsertSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        return this.executeSqlInsert(connection, sql, context, required, optional);
    }

    public String buildInsertSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        return this.buildInsertSql0(quote, table, context, required, optional).toString();
    }

    public abstract String buildInsertWithIdSql(String var1, String var2, Map<String, Object> var3, String[] var4, String[] var5);

    public StringBuilder buildInsertSql0(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        StringBuilder principal = new StringBuilder();
        StringBuilder auxiliar = new StringBuilder();
        principal.append("INSERT INTO ").append(quote).append(table).append(quote).append('(');
        auxiliar.append(") VALUES(");
        for (String parameter : required) {
            if (!context.containsKey(parameter)) {
                return null;
            }
            principal.append(quote).append(parameter).append(quote).append(',');
            auxiliar.append('?').append(',');
        }
        for (String parameter : optional) {
            if (!context.containsKey(parameter)) continue;
            principal.append(quote).append(parameter).append(quote).append(',');
            auxiliar.append('?').append(',');
        }
        int index = principal.length() - 1;
        if (principal.charAt(index) != ',') {
            return null;
        }
        principal.setLength(index);
        auxiliar.setLength(auxiliar.length() - 1);
        return principal.append((CharSequence)auxiliar).append(')');
    }

    public String buildUpdateSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        StringBuilder principal = new StringBuilder();
        StringBuilder auxiliar = new StringBuilder();
        principal.append("UPDATE ").append(quote).append(table).append(quote).append(" SET ");
        auxiliar.append(" WHERE ");
        for (String parameter : required) {
            if (!context.containsKey(parameter)) {
                LOGGER.error("Missing parameter: {}", (Object)parameter);
                throw new IllegalArgumentException("Missing required parameter: ".concat(parameter));
            }
            auxiliar.append(quote).append(parameter).append(quote).append("=? AND ");
        }
        if (!auxiliar.toString().endsWith(STR_AND)) {
            LOGGER.warn("No conditions in UPDATE");
            throw new IllegalStateException("No required parameters cofigured");
        }
        auxiliar.setLength(auxiliar.length() - 5);
        for (String parameter : optional) {
            if (!context.containsKey(parameter)) continue;
            principal.append(quote).append(parameter).append(quote).append("=?,");
        }
        int position = principal.length() - 1;
        if (principal.charAt(position) != ',') {
            LOGGER.warn("No data ^{}^ & ^{}^; required: {}, optional: {}", (Object)principal, (Object)auxiliar);
            return null;
        }
        principal.setLength(position);
        return principal.append((CharSequence)auxiliar).toString();
    }

    public String buildSelectSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        StringBuilder builder = new StringBuilder("SELECT ");
        for (String parameter : optional) {
            builder.append(quote).append(parameter).append(quote).append(',');
        }
        int position = builder.length() - 1;
        if (builder.charAt(position) != ',') {
            LOGGER.warn("No parameters");
            return null;
        }
        builder.setLength(position);
        builder.append(" FROM ").append(quote).append(table).append(quote);
        if (required.length == 0) {
            return builder.toString();
        }
        builder.append(" WHERE ");
        for (String parameter : required) {
            if (!context.containsKey(parameter)) {
                LOGGER.warn("Invalid parameter: {}", (Object)parameter);
                return null;
            }
            builder.append(quote).append(parameter).append(quote).append("=?").append(STR_AND);
        }
        position = builder.length() - 5;
        int count = 0;
        for (count = 0; count < 5 && STR_AND.charAt(count) == builder.charAt(position + count); ++count) {
        }
        if (count == 5) {
            return builder.substring(0, position);
        }
        LOGGER.warn("Size mismatch");
        return null;
    }

    Object[] setSelectParameters(Map<String, Object> context, String[] required, PreparedStatement statement) throws SQLException {
        int length = required.length;
        Object[] data = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object value = context.get(required[i]);
            statement.setObject(i + 1, value);
            data[i] = value;
        }
        return data;
    }

    Map<String, Object> extract(String[] optional, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : optional) {
            map.put(field, resultSet.getObject(field));
        }
        return map;
    }

    void logFailure(String name, String msg) {
        MESSAGE_LOGGER.warn("{}({}): failure", (Object)msg, (Object)name);
    }

    void logSuccess(String name, String msg) {
        MESSAGE_LOGGER.info("{}({}): success", (Object)msg, (Object)name);
    }

    static {
        assert (5 == STR_AND.length());
    }
}

