package net.sf.aguacate.util.dynamic.bridge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

import net.sf.aguacate.util.dynamic.bridge.spi.DynamicFactoryScript;

public final class DynamicFactoryCoupling {

	private static final ScriptEngineManager MANAGER;

	private static Map<String, DynamicFactoryScript> mimetypes;

	private static Map<String, DynamicFactoryScript> extensions;

	static {
		MANAGER = new ScriptEngineManager();
		mimetypes = Collections.emptyMap();
		extensions = Collections.emptyMap();
	}

	private DynamicFactoryCoupling() {
	}

	public static DynamicFactory getByExtension(String extension) {
		return getBy(true, extension);
	}

	public static DynamicFactory getByMimetype(String mimetype) {
		return getBy(false, mimetype);
	}

	static DynamicFactory getBy(boolean extension, String key) {
		Map<String, DynamicFactoryScript> map;
		if (extension) {
			map = extensions;
		} else {
			map = mimetypes;
		}
		DynamicFactoryScript factory = map.get(key);
		if (factory == null) {
			synchronized (MANAGER) {
				factory = map.get(key);
				if (factory == null) {
					if (extension) {
						for (DynamicFactoryScript current : extensions.values()) {
							List<String> list = current.getEngine().getFactory().getMimeTypes();
							if (list.contains(key)) {
								factory = current;
								break;
							}
						}
						if (factory == null) {
							for (DynamicFactoryScript current : mimetypes.values()) {
								List<String> list = current.getEngine().getFactory().getExtensions();
								if (list.contains(key)) {
									factory = current;
									break;
								}
							}
						}
					} else {
						for (DynamicFactoryScript current : mimetypes.values()) {
							List<String> list = current.getEngine().getFactory().getExtensions();
							if (list.contains(key)) {
								factory = current;
								break;
							}
						}
						if (factory == null) {
							for (DynamicFactoryScript current : extensions.values()) {
								List<String> list = current.getEngine().getFactory().getMimeTypes();
								if (list.contains(key)) {
									factory = current;
									break;
								}
							}
						}
					}
					if (factory == null) {
						ScriptEngine engine;
						if (extension) {
							engine = MANAGER.getEngineByExtension(key);
						} else {
							engine = MANAGER.getEngineByMimeType(key);
						}
						if (engine == null) {
							throw new IllegalArgumentException("No engine for: ".concat(key));
						}
						factory = new DynamicFactoryScript(engine);
					}
					Map<String, DynamicFactoryScript> dup = new HashMap<>(map);
					dup.put(key, factory);
					if (extension) {
						extensions = dup;
					} else {
						mimetypes = dup;
					}
				}
			}
		}
		return factory;
	}

}
