package net.sf.aguacate.util.codec.bridge.spi;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import net.sf.aguacate.util.codec.bridge.CodecBridge;

public class CodecBridgeObjectMapperJson implements CodecBridge {

	private static final String MIMETYPE = "application/json";

	private static final ObjectMapper MAPPER = new ObjectMapper();

	@Override
	public boolean support(String mimetype) {
		return MIMETYPE.equals(mimetype);
	}

	@Override
	@SuppressWarnings("unchecked")
	public Map<String, Object> decodeMap(Reader reader) throws IOException {
		return MAPPER.readValue(reader, Map.class);
	}

	@Override
	@SuppressWarnings("unchecked")
	public Map<String, Object> decodeMap(String json) throws IOException {
		return MAPPER.readValue(json, Map.class);
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<Object> decodeList(Reader reader) throws IOException {
		return MAPPER.readValue(reader, List.class);
	}

	@Override
	@SuppressWarnings("unchecked")
	public List<Object> decodeList(String json) throws IOException {
		return MAPPER.readValue(json, List.class);
	}

	@Override
	public String encode(Object object) {
		try {
			return MAPPER.writeValueAsString(object);
		} catch (JsonProcessingException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public void encode(Writer writer, Object object) throws IOException {
		try {
			MAPPER.writeValue(writer, object);
		} catch (JsonProcessingException e) {
			throw new IllegalStateException(e);
		}
	}

}
