package net.sf.aguacate.util.codec.bridge;

import net.sf.aguacate.util.codec.bridge.spi.CodecBridgeObjectMapperJson;
import net.sf.aguacate.util.codec.bridge.spi.CodecBridgeObjectMapperYaml;

public class CodecCoupling {

	private static final CodecBridge JSON_INSTANCE;

	private static final CodecBridge YAML_INSTANCE;

	static {
		JSON_INSTANCE = new CodecBridgeObjectMapperJson();
		YAML_INSTANCE = new CodecBridgeObjectMapperYaml();
	}

	public static CodecBridge jsonCodecBridge() {
		return JSON_INSTANCE;
	}

	public static CodecBridge yamlCodecBridge() {
		return YAML_INSTANCE;
	}

}
