/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.aguacate.util.resource.ResourceLocator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceLocatorClassImpl
implements ResourceLocator {
    private static final Logger LOGGER = LogManager.getLogger(ResourceLocatorClassImpl.class);
    private final Class<?> klass;

    public ResourceLocatorClassImpl(Class<?> klass) {
        this.klass = klass;
    }

    @Override
    public InputStream open(String resource) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            URL url = this.klass.getResource(resource);
            LOGGER.debug("resource: {}", (Object)url);
            if (url == null) {
                return null;
            }
            return url.openStream();
        }
        return this.klass.getResourceAsStream(resource);
    }
}

