/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StaticHeadersFilter
implements Filter {
    private final Map<String, String> headers = new HashMap<String, String>();

    public void init(FilterConfig config) throws ServletException {
        Enumeration names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.headers.put(name, config.getInitParameter(name));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            response.setHeader(header.getKey(), header.getValue());
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

