package net.sf.aguacate.util.config.database;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface DatabaseInterface {

	String getVendor();

	Map<String, Object> executeSqlSelectSingleRow(Connection connection, String sql, Map<String, Object> context,
			String[] required, String[] optional) throws SQLException;

	List<Map<String, Object>> executeSqlSelectMultipleRow(Connection connection, String sql,
			Map<String, Object> context, String[] required, String[] optional) throws SQLException;

	Object executeSqlSelectValue(Connection connection, String sql, Map<String, Object> context, String[] required,
			String[] optional) throws SQLException;

	int executeSqlUpdate(Connection connection, String sql, Map<String, Object> context, String[] required,
			String[] optional) throws SQLException;

	int executeSqlInsert(Connection connection, String sql, Map<String, Object> context, String[] required,
			String[] optional) throws SQLException;

	BigInteger executeSqlInsertWithId(Connection connection, String sql, Map<String, Object> context, String[] required,
			String[] optional, String[] keys) throws SQLException;

	Map<String, Object> executeSelectSingleRow(Connection connection, String table, Map<String, Object> context,
			String[] required, String[] optional) throws SQLException;

	List<Map<String, Object>> executeSelectMultipleRow(Connection connection, String table, Map<String, Object> context,
			String[] required, String[] optional) throws SQLException;

	Object executeSelectValue(Connection connection, String table, Map<String, Object> context, String[] required,
			String[] optional) throws SQLException;

	int executeUpdate(Connection connection, String table, Map<String, Object> context, String[] required,
			String[] optional) throws SQLException;

	int executeInsert(Connection connection, String table, Map<String, Object> context, String[] required,
			String[] optional) throws SQLException;

	BigInteger executeInsertWithId(Connection connection, String table, Map<String, Object> context, String[] required,
			String[] optional, String[] keys) throws SQLException;

}
