package net.sf.aguacate.util.config.datasource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import net.sf.aguacate.util.config.datasource.spi.DataSourceLoaderImpl;

public class DataSourceCoupling {

	private static final DataSourceLoader LOADER;

	private static Map<String, DataSource> dataSources;

	static {
		LOADER = new DataSourceLoaderImpl();
		dataSources = Collections.emptyMap();
	}

	public static DataSource getDataSource(String name) {
		DataSource dataSource = dataSources.get(name);
		if (dataSource == null) {
			synchronized (DataSourceCoupling.class) {
				dataSource = dataSources.get(name);
				if (dataSource == null) {
					dataSource = LOADER.getDataSource(name);
					if (dataSource != null) {
						Map<String, DataSource> temp = new HashMap<>(dataSources);
						temp.put(name, dataSource);
						dataSources = temp;
					}
				}
			}
		}
		return dataSource;
	}

}
