/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.datasource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.aguacate.util.config.datasource.DataSourceLoader;
import net.sf.aguacate.util.config.datasource.spi.DataSourceLoaderImpl;

public class DataSourceCoupling {
    private static final DataSourceLoader LOADER = new DataSourceLoaderImpl();
    private static Map<String, DataSource> dataSources = Collections.emptyMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSource getDataSource(String name) {
        DataSource dataSource = dataSources.get(name);
        if (dataSource != null) return dataSource;
        Class<DataSourceCoupling> clazz = DataSourceCoupling.class;
        synchronized (DataSourceCoupling.class) {
            dataSource = dataSources.get(name);
            if (dataSource != null || (dataSource = LOADER.getDataSource(name)) == null) return dataSource;
            HashMap<String, DataSource> temp = new HashMap<String, DataSource>(dataSources);
            temp.put(name, dataSource);
            dataSources = temp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return dataSource;
        }
    }
}

