/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.aguacate.util.config.database.DatabaseBridge;
import net.sf.aguacate.util.config.database.DatabaseConfigurationLoader;
import net.sf.aguacate.util.config.database.spi.DatabaseBridgeLoaderSpi;

public class DatabaseCoupling {
    private static final DatabaseConfigurationLoader LOADER = new DatabaseBridgeLoaderSpi();
    private static Map<String, DatabaseBridge> bridges = Collections.emptyMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseBridge getDatabaseBridge(String name) {
        DatabaseBridge bridge = bridges.get(name);
        if (bridge != null) return bridge;
        Class<DatabaseCoupling> clazz = DatabaseCoupling.class;
        synchronized (DatabaseCoupling.class) {
            bridge = bridges.get(name);
            if (bridge != null) return bridge;
            bridge = LOADER.get(name);
            if (bridge == null) {
                throw new IllegalStateException(name);
            }
            HashMap<String, DatabaseBridge> temp = new HashMap<String, DatabaseBridge>(bridges);
            temp.put(name, bridge);
            bridges = temp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bridge;
        }
    }
}

