/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database.spi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.aguacate.util.config.database.DatabaseBridge;
import net.sf.aguacate.util.config.database.DatabaseConfigurationLoader;
import net.sf.aguacate.util.config.database.spi.DatabaseInterfaceMysql;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseBridgeLoaderSpi
implements DatabaseConfigurationLoader {
    private static final Logger LOGGER = LogManager.getLogger(DatabaseBridgeLoaderSpi.class);
    private static final String DIRECTORY = "DIRECTORY_DATABASE";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ResourceLocator locator;

    public DatabaseBridgeLoaderSpi() {
        String temp = System.getProperty(DIRECTORY);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(DIRECTORY);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_DATABASE defined, using default");
                this.locator = new ResourceLocatorClassImpl(DatabaseBridgeLoaderSpi.class);
            } else {
                LOGGER.info("using DIRECTORY_DATABASE (env): {}", (Object)temp);
                this.locator = new ResourceLocatorFileImpl(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_DATABASE (prop): {}", (Object)temp);
            this.locator = new ResourceLocatorFileImpl(temp);
        }
    }

    @Override
    public DatabaseBridge get(String name) {
        String file = name.concat(".json");
        LOGGER.debug("trying to load {}", (Object)file);
        try {
            Map<String, Object> configuration = this.readConfiguration(file);
            String vendor = (String)configuration.get("vendor");
            if ("mysql".equalsIgnoreCase(vendor)) {
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)((Map)configuration.get("properties")));
                HikariDataSource ds = new HikariDataSource(new HikariConfig(properties));
                LOGGER.info("Succesful load of {}", (Object)name);
                return new DatabaseBridge(new DatabaseInterfaceMysql(), (DataSource)ds);
            }
            throw new IllegalArgumentException(vendor);
        }
        catch (IOException e) {
            LOGGER.error("on opening resource", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    Map<String, Object> readConfiguration(String file) throws IOException {
        InputStream inputStream = this.locator.open(file);
        if (inputStream == null) {
            LOGGER.warn("no configuration for {}", (Object)file);
            throw new UnsupportedOperationException();
        }
        try {
            Map map = (Map)MAPPER.readValue((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), Map.class);
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("on closing resource", (Throwable)e);
            }
        }
    }
}

