/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database.spi;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import net.sf.aguacate.util.config.database.spi.AbstractDatabaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDatabaseInterfaceWithId
extends AbstractDatabaseInterface {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDatabaseInterfaceWithId.class);

    @Override
    public String buildInsertWithIdSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        return this.buildInsertSql0(quote, table, context, required, optional).toString();
    }

    @Override
    public BigInteger executeInsertWithId(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional, String[] keys) throws SQLException {
        String sql = this.buildInsertWithIdSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug("prepare: {}", (Object)sql);
        PreparedStatement statement = this.prepareStatement(connection, sql, keys);
        try {
            int position = 1;
            for (String parameter : required) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            for (String parameter : optional) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            LOGGER.debug("execution: {}", (Object)sql);
            int count = statement.executeUpdate();
            if (count == 1) {
                ResultSet generatedKeys = statement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    String key = generatedKeys.getString(1);
                    LOGGER.debug("result({}): {}", (Object)key, (Object)sql);
                    BigInteger bigInteger = new BigInteger(key);
                    return bigInteger;
                }
                LOGGER.warn("No primary key");
                throw new IllegalStateException("No primary key");
            }
            LOGGER.warn("Multiple rows: {}", (Object)count);
            throw new IllegalStateException("Multiple rows");
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    abstract PreparedStatement prepareStatement(Connection var1, String var2, String[] var3) throws SQLException;
}

