/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.database.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.util.config.database.DatabaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDatabaseInterface
implements DatabaseInterface {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDatabaseInterface.class);
    private static final String STR_AND = " AND ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> executeSelectSingleRow(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildSelectSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            block21: {
                Map<String, Object> map;
                this.setSelectParameters(context, required, statement);
                resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) break block21;
                    Map<String, Object> map2 = this.extract(optional, resultSet);
                    if (resultSet.next()) {
                        LOGGER.warn("Multiple results");
                    }
                    map = map2;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("On close resultSet", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("On close resultSet", (Throwable)e);
                }
                return map;
            }
            Map<String, Object> map = null;
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close resultSet", (Throwable)e);
            }
            return map;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> executeSelectMultipleRow(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildSelectSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            block27: {
                Map<String, Object> first;
                block28: {
                    ArrayList<Map<String, Object>> arrayList;
                    this.setSelectParameters(context, required, statement);
                    resultSet = statement.executeQuery();
                    try {
                        if (!resultSet.next()) break block27;
                        first = this.extract(optional, resultSet);
                        if (!resultSet.next()) break block28;
                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                        list.add(first);
                        do {
                            list.add(this.extract(optional, resultSet));
                        } while (resultSet.next());
                        arrayList = list;
                    }
                    catch (Throwable throwable) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("On close resultSet", (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("On close resultSet", (Throwable)e);
                    }
                    return arrayList;
                }
                List<Map<String, Object>> list = Collections.singletonList(first);
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("On close resultSet", (Throwable)e);
                }
                return list;
            }
            List<Map<String, Object>> list = null;
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close resultSet", (Throwable)e);
            }
            return list;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeSelectValue(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildSelectSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            ResultSet resultSet;
            block21: {
                Object object;
                this.setSelectParameters(context, required, statement);
                resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) break block21;
                    Object value = resultSet.getObject(1);
                    if (resultSet.next()) {
                        LOGGER.warn("Multiple rows");
                    }
                    object = value;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        LOGGER.error("On close resultSet", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("On close resultSet", (Throwable)e);
                }
                return object;
            }
            Object var9_10 = null;
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close resultSet", (Throwable)e);
            }
            return var9_10;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildUpdateSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            int position = 1;
            for (String parameter : optional) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            for (String parameter : required) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeInsert(Connection connection, String table, Map<String, Object> context, String[] required, String[] optional) throws SQLException {
        String sql = this.buildInsertSql(connection.getMetaData().getIdentifierQuoteString(), table, context, required, optional);
        LOGGER.debug(sql);
        PreparedStatement statement = connection.prepareStatement(sql);
        try {
            int position = 1;
            for (String parameter : required) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            for (String parameter : optional) {
                if (!context.containsKey(parameter)) continue;
                statement.setObject(position, context.get(parameter));
                ++position;
            }
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error("On close statement", (Throwable)e);
            }
        }
    }

    public String buildInsertSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        return this.buildInsertSql0(quote, table, context, required, optional).toString();
    }

    public abstract String buildInsertWithIdSql(String var1, String var2, Map<String, Object> var3, String[] var4, String[] var5);

    public StringBuilder buildInsertSql0(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        StringBuilder principal = new StringBuilder();
        StringBuilder auxiliar = new StringBuilder();
        principal.append("INSERT INTO ").append(quote).append(table).append(quote).append('(');
        auxiliar.append(") VALUES(");
        for (String parameter : required) {
            if (!context.containsKey(parameter)) {
                return null;
            }
            principal.append(quote).append(parameter).append(quote).append(',');
            auxiliar.append('?').append(',');
        }
        for (String parameter : optional) {
            if (!context.containsKey(parameter)) continue;
            principal.append(quote).append(parameter).append(quote).append(',');
            auxiliar.append('?').append(',');
        }
        int index = principal.length() - 1;
        if (principal.charAt(index) != ',') {
            return null;
        }
        principal.setLength(index);
        auxiliar.setLength(auxiliar.length() - 1);
        return principal.append((CharSequence)auxiliar).append(')');
    }

    public String buildUpdateSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        StringBuilder principal = new StringBuilder();
        StringBuilder auxiliar = new StringBuilder();
        principal.append("UPDATE ").append(quote).append(table).append(quote).append(" SET ");
        auxiliar.append(" WHERE ");
        for (String parameter : required) {
            if (!context.containsKey(parameter)) {
                return null;
            }
            auxiliar.append(quote).append(parameter).append(quote).append("=? AND ");
        }
        if (!auxiliar.toString().endsWith(STR_AND)) {
            return null;
        }
        auxiliar.setLength(auxiliar.length() - STR_AND.length());
        for (String parameter : optional) {
            if (!context.containsKey(parameter)) continue;
            principal.append(quote).append(parameter).append(quote).append("=?,");
        }
        int position = principal.length() - 1;
        if (principal.charAt(position) != ',') {
            return null;
        }
        principal.setLength(position);
        return principal.append((CharSequence)auxiliar).toString();
    }

    public String buildSelectSql(String quote, String table, Map<String, Object> context, String[] required, String[] optional) {
        StringBuilder builder = new StringBuilder("SELECT ");
        for (String parameter : optional) {
            builder.append(quote).append(parameter).append(quote).append(',');
        }
        int position = builder.length() - 1;
        if (builder.charAt(position) != ',') {
            LOGGER.warn("No parameters");
            return null;
        }
        builder.setLength(position);
        builder.append(" FROM ").append(quote).append(table).append(quote);
        if (required.length == 0) {
            return builder.toString();
        }
        builder.append(" WHERE ");
        for (String parameter : required) {
            if (!context.containsKey(parameter)) {
                LOGGER.warn("Invalid parameter: {}", (Object)parameter);
                return null;
            }
            builder.append(quote).append(parameter).append(quote).append("=?").append(STR_AND);
        }
        int size = STR_AND.length();
        position = builder.length() - size;
        int count = 0;
        for (count = 0; count < size && STR_AND.charAt(count) == builder.charAt(position + count); ++count) {
        }
        if (count == size) {
            return builder.substring(0, position);
        }
        LOGGER.warn("Size mismatch");
        return null;
    }

    void setSelectParameters(Map<String, Object> context, String[] required, PreparedStatement statement) throws SQLException {
        int position = 1;
        for (String parameter : required) {
            statement.setObject(position, context.get(parameter));
            ++position;
        }
    }

    Map<String, Object> extract(String[] optional, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String field : optional) {
            map.put(field, resultSet.getObject(field));
        }
        return map;
    }
}

