package net.sf.aguacate.util.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.util.resource.ResourceLocator;

public class ResourceLocatorClassImpl implements ResourceLocator {

	private static final Logger LOGGER = LogManager.getLogger(ResourceLocatorClassImpl.class);

	private final Class<?> klass;

	public ResourceLocatorClassImpl(Class<?> klass) {
		this.klass = klass;
	}

	@Override
	public InputStream open(String resource) throws IOException {
		if (LOGGER.isDebugEnabled()) {
			URL url = klass.getResource(resource);
			LOGGER.debug("resource: {}", url);
			return url.openStream();
		} else {
			return klass.getResourceAsStream(resource);
		}
	}

}
