package net.sf.aguacate.util.config.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import net.sf.aguacate.util.config.database.spi.DatabaseBridgeLoaderSpi;

public class DatabaseCoupling {

	private static final DatabaseConfigurationLoader LOADER;

	private static Map<String, DatabaseBridge> bridges;

	static {
		LOADER = new DatabaseBridgeLoaderSpi();
		bridges = Collections.emptyMap();
	}

	public static DatabaseBridge getDatabaseBridge(String name) {
		DatabaseBridge bridge = bridges.get(name);
		if (bridge == null) {
			synchronized (DatabaseCoupling.class) {
				bridge = bridges.get(name);
				if (bridge == null) {
					bridge = LOADER.get(name);
					if (bridge == null) {
						throw new IllegalStateException(name);
					} else {
						Map<String, DatabaseBridge> temp = new HashMap<>(bridges);
						temp.put(name, bridge);
						bridges = temp;
					}
				}
			}
		}
		return bridge;
	}

}
