/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.config.datasource.spi;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.sql.DataSource;
import net.sf.aguacate.util.config.datasource.DataSourceLoader;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataSourceLoaderImpl
implements DataSourceLoader {
    private static final String DIRECTORY_DATASOURCE = "DIRECTORY_DATASOURCE";
    private static final Logger LOGGER = LogManager.getLogger(DataSourceLoaderImpl.class);
    private final ResourceLocator locator;

    public DataSourceLoaderImpl() {
        String temp = System.getProperty(DIRECTORY_DATASOURCE);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(DIRECTORY_DATASOURCE);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_DATASOURCE defined, using default");
                this.locator = new ResourceLocatorClassImpl(DataSourceLoaderImpl.class);
            } else {
                LOGGER.info("using DIRECTORY_DATASOURCE (env): {}", (Object)temp);
                this.locator = new ResourceLocatorFileImpl(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_DATASOURCE (prop): {}", (Object)temp);
            this.locator = new ResourceLocatorFileImpl(temp);
        }
    }

    @Override
    public DataSource getDataSource(String name) {
        String file = name.concat(".properties");
        LOGGER.debug("trying to load {}", (Object)file);
        try {
            Properties properties = this.toProperties(file);
            HikariDataSource ds = new HikariDataSource(new HikariConfig(properties));
            LOGGER.info("Succesful load of {}", (Object)name);
            return ds;
        }
        catch (IOException e) {
            LOGGER.error("on opening resource", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    Properties toProperties(String file) throws IOException {
        InputStream inputStream = this.locator.open(file);
        if (inputStream == null) {
            LOGGER.warn("no configuration for {}", (Object)file);
            throw new UnsupportedOperationException();
        }
        try {
            Properties properties = new Properties();
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            properties.load(reader);
            LOGGER.trace("readed properties: {}", (Object)properties);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("on closing resource", (Throwable)e);
            }
        }
    }
}

