/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.messages.Messages;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.jsoup.internal.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManualScenarioChecker {
    private final EnvironmentVariables environmentVariables;
    private static final String ANSI_RED = "\u001b[91m";
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String UNDEFINED_MANUAL_VERSION_TARGET_MESSAGE = System.lineSeparator() + "\u001b[91m" + "WARNING" + System.lineSeparator() + "The @manual and @manual-last-tested-version annotations were used in the Cucumber scenarios, " + System.lineSeparator() + "but no current.target.version was defined. For the @last-tested-version tag to work," + System.lineSeparator() + "You need to set the current.target.version to a corresponding value in your Serenity configuration file." + System.lineSeparator() + "\u001b[0m";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManualScenarioChecker.class);

    public ManualScenarioChecker(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean scenarioResultIsUpToDate(List<Messages.GherkinDocument.Feature.Tag> scenarioTags) {
        Optional<String> lastTestedVersion = this.lastTestedVersionFromTags(scenarioTags);
        Optional currentTargetVersion = ThucydidesSystemProperty.CURRENT_TARGET_VERSION.optionalFrom(this.environmentVariables);
        if (!lastTestedVersion.isPresent()) {
            return true;
        }
        if (!currentTargetVersion.isPresent() || StringUtil.isBlank((String)((String)currentTargetVersion.get()))) {
            LOGGER.warn(UNDEFINED_MANUAL_VERSION_TARGET_MESSAGE);
            return true;
        }
        return lastTestedVersion.get().equalsIgnoreCase((String)currentTargetVersion.get());
    }

    public Optional<String> lastTestedVersionFromTags(List<Messages.GherkinDocument.Feature.Tag> scenarioTags) {
        return scenarioTags.stream().filter(tag -> tag.getName().startsWith("@manual-last-tested:")).map(tag -> this.versionFrom(tag.getName())).findFirst();
    }

    private String versionFrom(String lastTestedVersionTag) {
        return lastTestedVersionTag.trim().substring("@manual-last-tested:".length()).trim();
    }

    public Optional<String> testEvidenceFromTags(List<Messages.GherkinDocument.Feature.Tag> scenarioTags) {
        return scenarioTags.stream().filter(tag -> tag.getName().startsWith("@manual-test-evidence:")).map(tag -> this.evidenceFrom(tag.getName())).findFirst();
    }

    private String evidenceFrom(String evidenceTag) {
        return evidenceTag.trim().substring("@manual-test-evidence:".length()).trim();
    }
}

