/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.text;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WordBag
implements Cloneable {
    private static final String CR = "\n";
    private HashMap<String, AtomicInteger> words;
    private String label;
    private int cachedMax;
    private boolean changed = true;
    private double cachedAverage;

    public WordBag(String bagLabel) {
        this.label = bagLabel.substring(0);
        this.words = new HashMap();
    }

    public WordBag(String bagName, HashMap<String, Integer> words) {
        this.label = bagName;
        this.words = new HashMap();
        for (Map.Entry<String, Integer> e : words.entrySet()) {
            this.words.put(e.getKey(), new AtomicInteger(e.getValue()));
        }
    }

    public synchronized void setLabel(String newBagLabel) {
        this.label = newBagLabel;
    }

    public synchronized String getLabel() {
        return this.label;
    }

    public synchronized void addWord(String word) {
        this.changed = true;
        if (this.words.containsKey(word)) {
            this.words.get(word).incrementAndGet();
        } else {
            this.words.put(word, new AtomicInteger(1));
        }
    }

    public synchronized void addWord(String word, Integer frequency) {
        this.changed = true;
        if (this.words.containsKey(word)) {
            int newFreq = this.words.get(word).intValue() + frequency;
            if (0 >= newFreq) {
                this.words.remove(word);
            } else {
                this.words.get(word).set(newFreq);
            }
        } else if (frequency > 0) {
            this.words.put(word, new AtomicInteger(frequency));
        }
    }

    public synchronized Integer getWordFrequency(String word) {
        if (this.words.containsKey(word)) {
            return this.words.get(word).intValue();
        }
        return 0;
    }

    public synchronized boolean contains(String word) {
        return this.words.keySet().contains(word);
    }

    public synchronized Collection<String> getWordSet() {
        return this.words.keySet();
    }

    public synchronized HashMap<String, Double> getWordsAsDoubles() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        for (Map.Entry<String, AtomicInteger> e : this.words.entrySet()) {
            res.put(e.getKey(), e.getValue().doubleValue());
        }
        return res;
    }

    public synchronized HashMap<String, Integer> getWords() {
        HashMap<String, Integer> res = new HashMap<String, Integer>(this.words.size());
        for (Map.Entry<String, AtomicInteger> e : this.words.entrySet()) {
            res.put(e.getKey(), e.getValue().intValue());
        }
        return res;
    }

    public synchronized HashMap<String, AtomicInteger> getInternalWords() {
        return this.words;
    }

    public synchronized int getTotalWordCount() {
        int res = 0;
        for (AtomicInteger count : this.words.values()) {
            res += count.intValue();
        }
        return res;
    }

    public synchronized void mergeWith(WordBag otherBag) {
        this.changed = true;
        for (Map.Entry<String, Integer> entry : otherBag.getWords().entrySet()) {
            if (this.words.containsKey(entry.getKey())) {
                this.words.get(entry.getKey()).set(this.words.get(entry.getKey()).intValue() + otherBag.getWordFrequency(entry.getKey()));
                continue;
            }
            this.words.put(entry.getKey(), new AtomicInteger(entry.getValue()));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.label).append(CR);
        for (Map.Entry<String, AtomicInteger> entry : this.words.entrySet()) {
            sb.append(entry.getKey()).append("\t").append(entry.getValue().intValue()).append(CR);
        }
        return sb.toString();
    }

    public String toColumn() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, AtomicInteger> entry : this.words.entrySet()) {
            for (int i = 0; i < entry.getValue().intValue(); ++i) {
                sb.append(entry.getKey()).append(CR);
            }
        }
        return sb.toString();
    }

    public synchronized int getMaxFrequency() {
        this.updateFrequenciesSummary();
        return this.cachedMax;
    }

    public synchronized double getAverageFrequency() {
        this.updateFrequenciesSummary();
        return this.cachedAverage;
    }

    private void updateFrequenciesSummary() {
        if (this.changed) {
            int res = 0;
            this.cachedMax = 0;
            for (AtomicInteger num : this.words.values()) {
                res += num.intValue();
                if (this.cachedMax >= num.intValue()) continue;
                this.cachedMax = num.intValue();
            }
            this.cachedAverage = (double)res / (double)this.words.size();
            this.changed = false;
        }
    }

    public WordBag clone() {
        WordBag res = new WordBag(this.label);
        for (Map.Entry<String, AtomicInteger> w : this.words.entrySet()) {
            res.addWord(w.getKey(), w.getValue().intValue());
        }
        return res;
    }
}

