/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.text;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.Alphabet;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.text.CosineDistanceMatrix;
import net.seninp.jmotif.text.Params;
import net.seninp.jmotif.text.WordBag;
import org.slf4j.LoggerFactory;

public final class TextProcessor {
    private static final String COMMA = ",";
    private static final String CR = "\n";
    private static final DecimalFormat df = new DecimalFormat("#0.00000");
    private static final Alphabet na = new NormalAlphabet();
    private static final TSProcessor tp = new TSProcessor();
    private static final SAXProcessor sp = new SAXProcessor();
    private static Logger consoleLogger;
    private static Level LOGGING_LEVEL;

    public WordBag seriesToWordBag(String label, double[] ts, Params params) throws SAXException {
        WordBag resultBag = new WordBag(label);
        char[] previousString = null;
        for (int i = 0; i <= ts.length - params.windowSize; ++i) {
            double[] subSection = Arrays.copyOfRange(ts, i, i + params.windowSize);
            subSection = tp.znorm(subSection, params.nThreshold);
            double[] paa = tp.paa(subSection, params.paaSize);
            char[] currentString = tp.ts2String(paa, na.getCuts(Integer.valueOf(params.alphabetSize)));
            if (null != previousString && (NumerosityReductionStrategy.EXACT.equals((Object)params.nrStartegy) && Arrays.equals(previousString, currentString) || NumerosityReductionStrategy.MINDIST.equals((Object)params.nrStartegy) && sp.checkMinDistIsZero(previousString, currentString))) continue;
            previousString = currentString;
            resultBag.addWord(String.valueOf(currentString));
        }
        return resultBag;
    }

    public List<WordBag> labeledSeries2WordBags(Map<String, List<double[]>> data, Params params) throws SAXException {
        HashMap<String, WordBag> preRes = new HashMap<String, WordBag>();
        for (Map.Entry<String, List<double[]>> e : data.entrySet()) {
            String classLabel = e.getKey();
            WordBag bag = new WordBag(classLabel);
            for (double[] series : e.getValue()) {
                WordBag cb = this.seriesToWordBag("tmp", series, params);
                bag.mergeWith(cb);
            }
            preRes.put(classLabel, bag);
        }
        ArrayList<WordBag> res = new ArrayList<WordBag>();
        res.addAll(preRes.values());
        return res;
    }

    public HashMap<String, HashMap<String, Double>> computeTFIDF(Collection<WordBag> texts) {
        int totalDocs = texts.size();
        HashMap<String, HashMap<String, Double>> res = new HashMap<String, HashMap<String, Double>>();
        HashMap<String, AtomicInteger> allWords = new HashMap<String, AtomicInteger>();
        for (WordBag bag : texts) {
            res.put(bag.getLabel(), new HashMap());
            for (Map.Entry<String, AtomicInteger> e : bag.getInternalWords().entrySet()) {
                if (allWords.containsKey(e.getKey())) {
                    ((AtomicInteger)allWords.get(e.getKey())).incrementAndGet();
                    continue;
                }
                allWords.put(e.getKey(), new AtomicInteger(1));
            }
        }
        for (WordBag bag : texts) {
            String bagName = bag.getLabel();
            HashMap<String, AtomicInteger> bagWords = bag.getInternalWords();
            for (Map.Entry word : allWords.entrySet()) {
                double tfidf = 0.0;
                if (bagWords.containsKey(word.getKey()) & totalDocs != ((AtomicInteger)word.getValue()).intValue()) {
                    int wordInBagFrequency = bagWords.get(word.getKey()).intValue();
                    double tfValue = 1.0 + Math.log(Integer.valueOf(wordInBagFrequency).doubleValue());
                    double idfLOGValue = Math.log10(Integer.valueOf(totalDocs).doubleValue() / ((AtomicInteger)word.getValue()).doubleValue());
                    tfidf = tfValue * idfLOGValue;
                }
                res.get(bagName).put((String)word.getKey(), tfidf);
            }
        }
        return res;
    }

    public double logTF(WordBag bag, String term) {
        if (bag.contains(term)) {
            return 1.0 + Math.log(bag.getWordFrequency(term).doubleValue());
        }
        return 0.0;
    }

    public double normalizedTF(WordBag bag, String term) {
        if (bag.contains(term)) {
            return Integer.valueOf(bag.getWordFrequency(term)).doubleValue() / Integer.valueOf(bag.getMaxFrequency()).doubleValue();
        }
        return 0.0;
    }

    public double augmentedTF(WordBag bag, String term) {
        if (bag.contains(term)) {
            return 0.5 + Integer.valueOf(bag.getWordFrequency(term)).doubleValue() / (2.0 * Integer.valueOf(bag.getMaxFrequency()).doubleValue());
        }
        return 0.0;
    }

    public double logAveTF(WordBag bag, String term) {
        if (bag.contains(term)) {
            return (1.0 + Math.log(Integer.valueOf(bag.getWordFrequency(term)).doubleValue())) / (1.0 + Math.log(bag.getAverageFrequency()));
        }
        return 0.0;
    }

    public int df(HashMap<String, WordBag> bags, String string) {
        int res = 0;
        for (WordBag b : bags.values()) {
            if (!b.contains(string)) continue;
            ++res;
        }
        return res;
    }

    public double idf(HashMap<String, WordBag> bags, String string) {
        return Integer.valueOf(bags.size()).doubleValue() / Integer.valueOf(this.df(bags, string)).doubleValue();
    }

    public String tfidfToTable(HashMap<String, HashMap<String, Double>> tfidf) {
        TreeSet<String> words = new TreeSet<String>();
        for (HashMap<String, Double> t : tfidf.values()) {
            words.addAll(t.keySet());
        }
        StringBuilder sb = new StringBuilder("\"\",");
        for (String key : tfidf.keySet()) {
            sb.append("\"").append(key).append("\",");
        }
        sb.delete(sb.length() - 1, sb.length()).append(CR);
        for (String w : words) {
            int zeroCounter = 0;
            StringBuffer rowSB = new StringBuffer();
            rowSB.append("\"").append(w).append("\",");
            for (String key : tfidf.keySet()) {
                HashMap<String, Double> data = tfidf.get(key);
                if (data.keySet().contains(w)) {
                    rowSB.append(data.get(w)).append(COMMA);
                    if (!data.get(w).equals(0.0)) continue;
                    ++zeroCounter;
                    continue;
                }
                rowSB.append(df.format(0.0)).append(COMMA);
                ++zeroCounter;
            }
            rowSB.delete(rowSB.length() - 1, rowSB.length()).append(CR);
            if (zeroCounter == tfidf.keySet().size()) continue;
            sb.append(rowSB.toString());
        }
        return sb.toString();
    }

    public HashMap<String, Double> normalizeToUnitVector(HashMap<String, Double> vector) {
        double sum = 0.0;
        for (double value : vector.values()) {
            sum += value * value;
        }
        sum = Math.sqrt(sum);
        HashMap<String, Double> res = new HashMap<String, Double>();
        for (Map.Entry<String, Double> e : vector.entrySet()) {
            res.put(e.getKey(), e.getValue() / sum);
        }
        return res;
    }

    public HashMap<String, HashMap<String, Double>> normalizeToUnitVectors(HashMap<String, HashMap<String, Double>> data) {
        HashMap<String, HashMap<String, Double>> res = new HashMap<String, HashMap<String, Double>>();
        for (Map.Entry<String, HashMap<String, Double>> e : data.entrySet()) {
            double sum = 0.0;
            for (double el : e.getValue().values()) {
                if (0.0 == el) continue;
                sum += el * el;
            }
            double sqRoot = Math.sqrt(sum);
            HashMap<String, Double> newEntry = new HashMap<String, Double>(e.getValue().size());
            for (Map.Entry<String, Double> val : e.getValue().entrySet()) {
                if (val.getValue().equals(0.0)) {
                    newEntry.put(val.getKey(), 0.0);
                    continue;
                }
                newEntry.put(val.getKey(), val.getValue() / sqRoot);
            }
            res.put(e.getKey(), newEntry);
        }
        return res;
    }

    public double cosineDistance(HashMap<String, Double> map1, HashMap<String, Double> map2) {
        Set<String> unionKey = map2.keySet();
        if (!map1.keySet().equals(map2.keySet())) {
            System.err.println("WARN: Uneven vectors in the cosineDistance(), adjusting...");
            unionKey = new HashSet<String>(map1.keySet());
            unionKey.retainAll(map2.keySet());
        }
        double[] vector1 = new double[unionKey.size()];
        double[] vector2 = new double[unionKey.size()];
        int i = 0;
        for (String s : unionKey) {
            vector1[i] = map1.get(s);
            vector2[i] = map2.get(s);
            ++i;
        }
        double numerator = this.dotProduct(vector1, vector2);
        double denominator = this.magnitude(map1.values()) * this.magnitude(map2.values());
        return numerator / denominator;
    }

    public double cosineSimilarity(WordBag testSample, HashMap<String, Double> weightVector) {
        double res = 0.0;
        for (Map.Entry<String, Integer> entry : testSample.getWords().entrySet()) {
            if (!weightVector.containsKey(entry.getKey())) continue;
            res += entry.getValue().doubleValue() * weightVector.get(entry.getKey());
        }
        double m1 = this.magnitude(testSample.getWordsAsDoubles().values());
        double m2 = this.magnitude(weightVector.values());
        return res / (m1 * m2);
    }

    public CosineDistanceMatrix getCosineDistanceMatrix(HashMap<String, HashMap<String, Double>> tfidf) {
        CosineDistanceMatrix res = new CosineDistanceMatrix(tfidf);
        return res;
    }

    public double magnitude(double[] vector) {
        return Math.sqrt(this.dotProduct(vector, vector));
    }

    public double magnitude(Double[] vector) {
        return Math.sqrt(this.dotProduct(vector, vector));
    }

    public double cosineSimilarityInstrumented(WordBag testSample, HashMap<String, Double> weightVector, HashMap<String, Double> insight) {
        double res = 0.0;
        for (Map.Entry<String, Integer> entry : testSample.getWords().entrySet()) {
            if (!weightVector.containsKey(entry.getKey())) continue;
            res += entry.getValue().doubleValue() * weightVector.get(entry.getKey());
            insight.put(entry.getKey(), entry.getValue().doubleValue() * weightVector.get(entry.getKey()));
        }
        double m1 = this.magnitude(testSample.getWordsAsDoubles().values());
        double m2 = this.magnitude(weightVector.values());
        return res / (m1 * m2);
    }

    private double magnitude(Collection<Double> values) {
        Double res = 0.0;
        for (Double v : values) {
            res = res + v * v;
        }
        return Math.sqrt(res);
    }

    public double dotProduct(double[] vector1, double[] vector2) {
        double res = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            res += vector1[i] * vector2[i];
        }
        return res;
    }

    public double dotProduct(Double[] vector1, Double[] vector2) {
        double res = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            res += vector1[i] * vector2[i];
        }
        return res;
    }

    public int classify(String classKey, double[] series, HashMap<String, HashMap<String, Double>> tfidf, Params params) throws SAXException {
        WordBag test = this.seriesToWordBag("test", series, params);
        return this.classify(classKey, test, tfidf);
    }

    public int classify(String trueClassLabel, WordBag test, HashMap<String, HashMap<String, Double>> tfidf) {
        double minDist = Double.MIN_VALUE;
        String className = "";
        double[] cosines = new double[tfidf.entrySet().size()];
        int index = 0;
        for (Map.Entry<String, HashMap<String, Double>> e : tfidf.entrySet()) {
            double dist;
            cosines[index] = dist = this.cosineSimilarity(test, e.getValue());
            ++index;
            if (!(dist > minDist)) continue;
            className = e.getKey();
            minDist = dist;
        }
        boolean allEqual = true;
        double cosine = cosines[0];
        for (int i = 1; i < cosines.length; ++i) {
            if (cosines[i] == cosine) continue;
            allEqual = false;
        }
        if (!allEqual && className.equalsIgnoreCase(trueClassLabel)) {
            return 1;
        }
        return 0;
    }

    public String classify(WordBag test, HashMap<String, HashMap<String, Double>> tfidf) {
        double minDist = Double.MIN_VALUE;
        String className = "";
        double[] cosines = new double[tfidf.entrySet().size()];
        int index = 0;
        for (Map.Entry<String, HashMap<String, Double>> e : tfidf.entrySet()) {
            double dist;
            cosines[index] = dist = this.cosineSimilarity(test, e.getValue());
            ++index;
            if (!(dist > minDist)) continue;
            className = e.getKey();
            minDist = dist;
        }
        return className;
    }

    public String wordBagToTable(WordBag bag) {
        TreeSet<String> words = new TreeSet<String>();
        words.addAll(bag.getWordSet());
        StringBuilder sb = new StringBuilder("\"" + bag.getLabel() + "\"").append(CR);
        for (String w : words) {
            Integer count = bag.getWordFrequency(w);
            if (count == 0) continue;
            sb.append("\"").append(w).append("\",");
            sb.append(count).append(CR);
        }
        return sb.toString();
    }

    public String bagsToTable(List<WordBag> bags) {
        TreeSet<String> words = new TreeSet<String>();
        for (WordBag bag : bags) {
            words.addAll(bag.getWordSet());
        }
        LinkedHashMap<String, Integer> bagKeys = new LinkedHashMap<String, Integer>();
        StringBuilder sb = new StringBuilder("\"\",");
        int index = 0;
        for (WordBag bag : bags) {
            bagKeys.put(bag.getLabel(), index);
            ++index;
            sb.append("\"").append(bag.getLabel()).append("\",");
        }
        sb.delete(sb.length() - 1, sb.length()).append(CR);
        for (String w : words) {
            int zeroCounter = 0;
            StringBuffer rowSB = new StringBuffer();
            rowSB.append("\"").append(w).append("\",");
            for (Map.Entry bagKey : bagKeys.entrySet()) {
                WordBag bag = bags.get((Integer)bagKey.getValue());
                HashMap<String, Integer> data = bag.getWords();
                if (data.keySet().contains(w)) {
                    rowSB.append(data.get(w)).append(COMMA);
                    if (!data.get(w).equals(0)) continue;
                    ++zeroCounter;
                    continue;
                }
                rowSB.append(0).append(COMMA);
                ++zeroCounter;
            }
            rowSB.delete(rowSB.length() - 1, rowSB.length()).append(CR);
            if (zeroCounter == bags.size()) continue;
            sb.append(rowSB.toString());
        }
        return sb.toString();
    }

    static {
        LOGGING_LEVEL = Level.DEBUG;
        consoleLogger = (Logger)LoggerFactory.getLogger(TextProcessor.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

