/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.text;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import net.seninp.jmotif.text.TextProcessor;

public class CosineDistanceMatrix {
    private double[][] distances;
    private String[] rows;
    private HashMap<String, Integer> keysToIndex = new HashMap();
    private static final String COMMA = ",";
    private static final String CR = "\n";
    private static final DecimalFormat df = new DecimalFormat("#0.00000");
    private static final TextProcessor tp = new TextProcessor();

    public CosineDistanceMatrix(HashMap<String, HashMap<String, Double>> tfidf) {
        Locale.setDefault(Locale.US);
        this.rows = tfidf.keySet().toArray(new String[0]);
        Arrays.sort(this.rows);
        this.distances = new double[this.rows.length][this.rows.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.keysToIndex.put(this.rows[i], i);
            for (int j = 0; j < i; ++j) {
                double distance;
                HashMap<String, Double> vectorA = tfidf.get(this.rows[i]);
                HashMap<String, Double> vectorB = tfidf.get(this.rows[j]);
                this.distances[i][j] = distance = tp.cosineDistance(vectorA, vectorB);
            }
        }
    }

    public String[] getRows() {
        return this.rows;
    }

    public double[][] getDistances() {
        return this.distances;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\"\",");
        for (String s : this.rows) {
            sb.append("\"").append(s).append("\"").append(COMMA);
        }
        sb.delete(sb.length() - 1, sb.length()).append(CR);
        for (int i = 0; i < this.rows.length; ++i) {
            sb.append("\"").append(this.rows[i]).append("\",");
            for (int j = 0; j < this.rows.length; ++j) {
                sb.append(df.format(this.distances[i][j])).append(COMMA);
            }
            sb.delete(sb.length() - 1, sb.length()).append(CR);
        }
        return sb.toString();
    }

    public double distanceBetween(String keyA, String keyB) {
        if (this.keysToIndex.get(keyA) >= this.keysToIndex.get(keyB)) {
            return this.distances[this.keysToIndex.get(keyA)][this.keysToIndex.get(keyB)];
        }
        return this.distances[this.keysToIndex.get(keyB)][this.keysToIndex.get(keyA)];
    }

    public void transformForHC() {
        for (int i = 0; i < this.distances.length; ++i) {
            for (int j = 0; j < this.distances[0].length; ++j) {
                this.distances[i][j] = 1.0 - this.distances[i][j];
            }
        }
    }
}

