/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.direct;

import net.seninp.jmotif.direct.Point;
import net.seninp.jmotif.direct.ValuePoint;

public class ValuePointColored
implements Comparable<ValuePoint> {
    private final Point point;
    private final double value;
    private boolean best;
    private static final ValuePointColored DEFAULT = new ValuePointColored(Point.getDefault(), Double.NaN, false);

    private ValuePointColored(Point point, double value, boolean best) {
        this.point = point;
        this.value = value;
        this.best = best;
    }

    public static ValuePointColored getDefault() {
        return DEFAULT;
    }

    public static ValuePointColored at(Point p, double value, boolean best) {
        return new ValuePointColored(p, value, best);
    }

    public double getValue() {
        return this.value;
    }

    public Point getPoint() {
        return this.point;
    }

    public boolean getBest() {
        return this.best;
    }

    public void setBest(boolean best) {
        this.best = best;
    }

    public String toString() {
        return this.value + "@" + this.point;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValuePointColored other = (ValuePointColored)obj;
        if (!(this.point == other.point || this.point != null && this.point.equals(other.point))) {
            return false;
        }
        return this.value == other.value;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.point != null ? this.point.hashCode() : 0);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    @Override
    public int compareTo(ValuePoint o) {
        if (this.getValue() > o.getValue()) {
            return 1;
        }
        if (this.getValue() < o.getValue()) {
            return -1;
        }
        return 0;
    }
}

