/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.direct;

import net.seninp.jmotif.direct.Point;

public class ValuePoint
implements Comparable<ValuePoint> {
    private final Point point;
    private final double value;
    private static final ValuePoint DEFAULT = new ValuePoint(Point.getDefault(), Double.NaN);

    private ValuePoint(Point point, double value) {
        this.point = point;
        this.value = value;
    }

    public static ValuePoint getDefault() {
        return DEFAULT;
    }

    public static ValuePoint at(Point p, double value) {
        return new ValuePoint(p, value);
    }

    public double getValue() {
        return this.value;
    }

    public Point getPoint() {
        return this.point;
    }

    public String toString() {
        return this.value + "@" + this.point;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValuePoint other = (ValuePoint)obj;
        if (!(this.point == other.point || this.point != null && this.point.equals(other.point))) {
            return false;
        }
        return this.value == other.value;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.point != null ? this.point.hashCode() : 0);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.value) ^ Double.doubleToLongBits(this.value) >>> 32);
        return hash;
    }

    @Override
    public int compareTo(ValuePoint o) {
        if (this.getValue() > o.getValue()) {
            return 1;
        }
        if (this.getValue() < o.getValue()) {
            return -1;
        }
        return 0;
    }
}

