/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.direct;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.seninp.jmotif.direct.TfIdfEntryComparator;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.text.Params;
import net.seninp.jmotif.text.TextProcessor;
import net.seninp.jmotif.text.WordBag;
import net.seninp.util.UCRUtils;
import org.slf4j.LoggerFactory;

public class SAXVSMPatternExplorer {
    private static final int MAX_WORDS_2_PRINT = 5;
    private static final int MAX_SERIES_2PRINT = 5;
    private static final int MAX_PATTERNS_2PRINT = 5;
    private static String TRAINING_DATA;
    private static String TEST_DATA;
    private static Integer WINDOW_SIZE;
    private static Integer PAA_SIZE;
    private static Integer ALPHABET_SIZE;
    private static Map<String, List<double[]>> trainData;
    private static Map<String, List<double[]>> testData;
    private static NumerosityReductionStrategy STRATEGY;
    private static final DecimalFormatSymbols otherSymbols;
    private static DecimalFormat df;
    private static final String CR = "\n";
    private static final TSProcessor tsp;
    private static final TextProcessor tp;
    private static final Logger consoleLogger;
    private static final Level LOGGING_LEVEL;

    public static void main(String[] args) throws Exception {
        Double weight;
        ArrayList<Map.Entry<String, Double>> values;
        String className;
        try {
            consoleLogger.info("processing paramleters: " + Arrays.toString(args));
            TRAINING_DATA = args[0];
            TEST_DATA = args[1];
            trainData = UCRUtils.readUCRData((String)TRAINING_DATA);
            consoleLogger.info("trainData classes: " + trainData.size() + ", series length: " + trainData.entrySet().iterator().next().getValue().get(0).length);
            for (Map.Entry<String, List<double[]>> e : trainData.entrySet()) {
                consoleLogger.info(" training class: " + e.getKey() + " series: " + e.getValue().size());
            }
            testData = UCRUtils.readUCRData((String)TEST_DATA);
            consoleLogger.info("testData classes: " + testData.size() + ", series length: " + testData.entrySet().iterator().next().getValue().get(0).length);
            for (Map.Entry<String, List<double[]>> e : testData.entrySet()) {
                consoleLogger.info(" test class: " + e.getKey() + " series: " + e.getValue().size());
            }
            WINDOW_SIZE = Integer.valueOf(args[2]);
            PAA_SIZE = Integer.valueOf(args[3]);
            ALPHABET_SIZE = Integer.valueOf(args[4]);
            STRATEGY = NumerosityReductionStrategy.valueOf((String)args[5].toUpperCase());
        }
        catch (Exception e) {
            System.err.println("There was parameters error....");
            System.exit(-10);
        }
        Params params = new Params(WINDOW_SIZE, PAA_SIZE, ALPHABET_SIZE, 0.01, STRATEGY);
        List<WordBag> bags = tp.labeledSeries2WordBags(trainData, params);
        HashMap<String, HashMap<String, Double>> tfidf = tp.computeTFIDF(bags);
        tfidf = tp.normalizeToUnitVectors(tfidf);
        for (Map.Entry<String, HashMap<String, Double>> e : tfidf.entrySet()) {
            className = e.getKey();
            values = new ArrayList<Map.Entry<String, Double>>();
            values.addAll(e.getValue().entrySet());
            Collections.sort(values, new TfIdfEntryComparator());
            System.out.print("Class key: " + className + CR);
            for (int i = 0; i < 5; ++i) {
                String pattern = (String)((Map.Entry)values.get(i)).getKey();
                weight = (Double)((Map.Entry)values.get(i)).getValue();
                System.out.println("\"" + pattern + "\", " + weight);
            }
        }
        for (Map.Entry<String, HashMap<String, Double>> e : tfidf.entrySet()) {
            className = e.getKey();
            values = new ArrayList();
            values.addAll(e.getValue().entrySet());
            Collections.sort(values, new TfIdfEntryComparator());
            System.out.print("Class key: " + className + CR);
            for (int i = 0; i < 5; ++i) {
                String pattern = (String)((Map.Entry)values.get(i)).getKey();
                weight = (Double)((Map.Entry)values.get(i)).getValue();
                System.out.println("pattern=\"" + pattern + "\"; weight=" + df.format(weight));
                StringBuffer seriesBuff = new StringBuffer("series = c(");
                StringBuffer offsetBuff = new StringBuffer("offsets = c(");
                Map<Integer, Integer[]> hits = SAXVSMPatternExplorer.getPatternLocationsForTheClass(className, trainData, pattern, params);
                int k = 0;
                int printedK = 0;
                do {
                    if (hits.get(k).length <= 0) continue;
                    System.out.print(k + ": " + Arrays.toString((Object[])hits.get(k)) + ", ");
                    System.out.println(Arrays.toString(trainData.get(className).get(k)));
                    System.out.println(Arrays.toString(SAXVSMPatternExplorer.seriesValuesAsHeat(trainData.get(className).get(k), className, tfidf, params)));
                    Integer[] integerArray = hits.get(k);
                    int n = integerArray.length;
                    for (int j = 0; j < n; ++j) {
                        int offset = integerArray[j];
                        seriesBuff.append(String.valueOf(k + 1) + ",");
                        offsetBuff.append(String.valueOf(offset + 1) + ",");
                    }
                    ++printedK;
                } while (++k < hits.size() && printedK < 5);
                System.out.print(seriesBuff.delete(seriesBuff.length() - 1, seriesBuff.length()).toString() + ")" + CR);
                System.out.print(offsetBuff.delete(offsetBuff.length() - 1, offsetBuff.length()).toString() + ")" + CR + "#" + CR);
            }
            System.out.print("Missclassified for Class key: " + className + CR);
            List<double[]> testD = testData.get(className);
            int seriesIdx = 0;
            for (double[] series : testD) {
                int classificationResult = tp.classify(className, series, tfidf, params);
                if (0 == classificationResult) {
                    System.out.println(seriesIdx + 1);
                }
                ++seriesIdx;
            }
            System.out.println(" ============== ");
        }
    }

    private static double[] seriesValuesAsHeat(double[] series, String className, HashMap<String, HashMap<String, Double>> tfidf, Params params) throws Exception {
        NormalAlphabet a = new NormalAlphabet();
        double[] weights = new double[series.length];
        HashMap<String, Integer> words = new HashMap<String, Integer>();
        for (int i = 0; i <= series.length - params.getWindowSize(); ++i) {
            double[] subseries = tsp.subseriesByCopy(series, i, i + params.getWindowSize());
            double[] paa = tsp.paa(tsp.znorm(subseries, params.getnThreshold()), params.getPaaSize());
            char[] sax = tsp.ts2String(paa, a.getCuts(Integer.valueOf(params.getAlphabetSize())));
            words.put(String.valueOf(sax), i);
        }
        for (Map.Entry<String, HashMap<String, Double>> e : tfidf.entrySet()) {
            for (Map.Entry<String, Double> e1 : e.getValue().entrySet()) {
                if (!words.containsKey(e1.getKey())) continue;
                int idx = (Integer)words.get(e1.getKey());
                double increment = 0.0;
                if (className.equalsIgnoreCase(e.getKey())) {
                    increment = e1.getValue();
                }
                for (int i = 0; i < params.getWindowSize(); ++i) {
                    weights[idx + i] = weights[idx + i] + increment;
                }
            }
        }
        return weights;
    }

    private static Map<Integer, Integer[]> getPatternLocationsForTheClass(String className, Map<String, List<double[]>> trainData, String pattern, Params params) throws IndexOutOfBoundsException, Exception {
        NormalAlphabet a = new NormalAlphabet();
        HashMap<Integer, Integer[]> res = new HashMap<Integer, Integer[]>();
        int seriesCounter = 0;
        for (double[] series : trainData.get(className)) {
            ArrayList<Integer> arr = new ArrayList<Integer>();
            for (int i = 0; i <= series.length - params.getWindowSize(); ++i) {
                double[] paa = tsp.paa(tsp.znorm(tsp.subseriesByCopy(series, i, i + params.getWindowSize()), params.getnThreshold()), params.getPaaSize());
                char[] sax = tsp.ts2String(paa, a.getCuts(Integer.valueOf(params.getAlphabetSize())));
                if (!pattern.equalsIgnoreCase(String.valueOf(sax))) continue;
                arr.add(i);
            }
            res.put(seriesCounter, arr.toArray(new Integer[0]));
            ++seriesCounter;
        }
        return res;
    }

    static {
        STRATEGY = NumerosityReductionStrategy.EXACT;
        otherSymbols = new DecimalFormatSymbols(Locale.US);
        df = new DecimalFormat("0.00###", otherSymbols);
        tsp = new TSProcessor();
        tp = new TextProcessor();
        LOGGING_LEVEL = Level.INFO;
        consoleLogger = (Logger)LoggerFactory.getLogger(SAXVSMPatternExplorer.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

