/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.direct;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.beust.jcommander.JCommander;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.seninp.jmotif.direct.Point;
import net.seninp.jmotif.direct.SAXVSMCVErrorFunction;
import net.seninp.jmotif.direct.SAXVSMDirectSamplerParams;
import net.seninp.jmotif.direct.ValuePointColored;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.text.Params;
import net.seninp.jmotif.text.TextProcessor;
import net.seninp.jmotif.text.WordBag;
import net.seninp.util.StackTrace;
import net.seninp.util.UCRUtils;
import org.slf4j.LoggerFactory;

public class SAXVSMDirectSampler {
    private static final DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
    private static DecimalFormat fmt = new DecimalFormat("0.00###", otherSymbols);
    private static ArrayList<Double[]> centerPoints;
    private static ArrayList<Double[]> lengthsSide;
    private static ArrayList<Double> diagonalLength;
    private static ArrayList<Double> differentDiagonalLength;
    private static double[] diagonalsMinFunc;
    private static ArrayList<Double> functionValues;
    private static ArrayList<ValuePointColored> coordinates;
    private static HashMap<String, Double> functionHash;
    private static final double precision = 1.0E-16;
    private static int b;
    private static double[] resultMinimum;
    private static int sampledPoints;
    private static int rectangleCounter;
    private static int indexPotentialBestRec;
    private static double minFunctionValue;
    private static int dimensions;
    private static SAXVSMCVErrorFunction function;
    private static final Logger consoleLogger;
    private static final Level LOGGING_LEVEL;
    private static final String COMMA = ", ";
    private static final String CR = "\n";
    private static final int ITERATION_DELTA_THRESHOLD = 3;
    private static ValuePointColored minimum;
    private static int[] upperBounds;
    private static int[] lowerBounds;
    private static Map<String, List<double[]>> trainData;
    private static Map<String, List<double[]>> testData;
    private static TextProcessor tp;

    public static void main(String[] args) throws Exception {
        try {
            SAXVSMDirectSamplerParams params = new SAXVSMDirectSamplerParams();
            JCommander jct = new JCommander((Object)params);
            if (0 == args.length) {
                jct.usage();
                System.exit(-10);
            }
            jct.parse(args);
            StringBuffer sb = new StringBuffer(1024);
            sb.append("SAX-VSM DiRect Sampler").append(CR);
            sb.append("parameters:").append(CR);
            sb.append("  train data: ").append(SAXVSMDirectSamplerParams.TRAIN_FILE).append(CR);
            sb.append("  test data: ").append(SAXVSMDirectSamplerParams.TEST_FILE).append(CR);
            sb.append("  SAX sliding window sizes: ").append("[").append(SAXVSMDirectSamplerParams.SAX_WINDOW_SIZE_MIN).append(" - ").append(SAXVSMDirectSamplerParams.SAX_WINDOW_SIZE_MAX).append("]").append(CR);
            sb.append("  SAX PAA sizes: ").append("[").append(SAXVSMDirectSamplerParams.SAX_PAA_SIZE_MIN).append(" - ").append(SAXVSMDirectSamplerParams.SAX_PAA_SIZE_MAX).append("]").append(CR);
            sb.append("  SAX alphabet sizes: ").append("[").append(SAXVSMDirectSamplerParams.SAX_ALPHABET_SIZE_MIN).append(" - ").append(SAXVSMDirectSamplerParams.SAX_ALPHABET_SIZE_MAX).append("]").append(CR);
            sb.append("  SAX normalization threshold: ").append(SAXVSMDirectSamplerParams.SAX_NORM_THRESHOLD).append(CR);
            sb.append("  CV hold out: ").append(SAXVSMDirectSamplerParams.HOLD_OUT_NUM).append(CR);
            sb.append("  max Iterations: ").append(SAXVSMDirectSamplerParams.ITERATIONS_NUM).append(CR);
            sb.append("  Iteration halt threshold: ").append(SAXVSMDirectSamplerParams.ITERATIONS_BREAK_THRESHOLD).append(CR);
            consoleLogger.info(sb.toString());
            trainData = UCRUtils.readUCRData((String)SAXVSMDirectSamplerParams.TRAIN_FILE);
            consoleLogger.info("trainData classes: " + trainData.size() + ", series length: " + trainData.entrySet().iterator().next().getValue().get(0).length);
            for (Map.Entry<String, List<double[]>> e : trainData.entrySet()) {
                consoleLogger.info(" training class: " + e.getKey() + " series: " + e.getValue().size());
            }
            testData = UCRUtils.readUCRData((String)SAXVSMDirectSamplerParams.TEST_FILE);
            consoleLogger.info("testData classes: " + testData.size() + ", series length: " + testData.entrySet().iterator().next().getValue().get(0).length);
            for (Map.Entry<String, List<double[]>> e : testData.entrySet()) {
                consoleLogger.info(" test class: " + e.getKey() + " series: " + e.getValue().size());
            }
        }
        catch (Exception e) {
            System.err.println("There was an error...." + StackTrace.toString((Throwable)e));
            System.exit(-10);
        }
        Date start = new Date();
        lowerBounds = new int[]{SAXVSMDirectSamplerParams.SAX_WINDOW_SIZE_MIN, SAXVSMDirectSamplerParams.SAX_PAA_SIZE_MIN, SAXVSMDirectSamplerParams.SAX_ALPHABET_SIZE_MIN};
        upperBounds = new int[]{SAXVSMDirectSamplerParams.SAX_WINDOW_SIZE_MAX, SAXVSMDirectSamplerParams.SAX_PAA_SIZE_MAX, SAXVSMDirectSamplerParams.SAX_ALPHABET_SIZE_MAX};
        consoleLogger.info("running sampling for " + NumerosityReductionStrategy.MINDIST.toString() + " strategy...");
        Params classicParams = SAXVSMDirectSampler.sample(NumerosityReductionStrategy.MINDIST);
        consoleLogger.info("running sampling for " + NumerosityReductionStrategy.EXACT.toString() + " strategy...");
        Params exactParams = SAXVSMDirectSampler.sample(NumerosityReductionStrategy.EXACT);
        consoleLogger.info("running sampling for " + NumerosityReductionStrategy.NONE.toString() + " strategy...");
        Params noredParams = SAXVSMDirectSampler.sample(NumerosityReductionStrategy.NONE);
        Date finish = new Date();
        SAXVSMDirectSampler.classify(classicParams);
        SAXVSMDirectSampler.classify(exactParams);
        SAXVSMDirectSampler.classify(noredParams);
        consoleLogger.info("all done in # " + Long.valueOf(finish.getTime() - start.getTime()).toString() + " ms; that is " + SAXProcessor.timeToString((long)start.getTime(), (long)finish.getTime()));
    }

    private static void classify(Params params) throws Exception {
        List<WordBag> bags = tp.labeledSeries2WordBags(trainData, params);
        HashMap<String, HashMap<String, Double>> tfidf = tp.computeTFIDF(bags);
        int testSampleSize = 0;
        int positiveTestCounter = 0;
        for (String label : tfidf.keySet()) {
            List<double[]> testD = testData.get(label);
            for (double[] series : testD) {
                positiveTestCounter += tp.classify(label, series, tfidf, params);
                ++testSampleSize;
            }
        }
        double accuracy = (double)positiveTestCounter / (double)testSampleSize;
        double error = 1.0 - accuracy;
        consoleLogger.info("classification results: " + SAXVSMDirectSampler.toLogStr(params, accuracy, error));
        System.out.println(SAXVSMDirectSampler.toParserString(params, accuracy, error));
    }

    private static Params sample(NumerosityReductionStrategy strategy) {
        double[] params;
        int iterationCounter;
        function = new SAXVSMCVErrorFunction(trainData, SAXVSMDirectSamplerParams.HOLD_OUT_NUM, SAXVSMDirectSamplerParams.SAX_NORM_THRESHOLD, strategy);
        centerPoints = new ArrayList();
        lengthsSide = new ArrayList();
        diagonalLength = new ArrayList();
        differentDiagonalLength = new ArrayList();
        diagonalsMinFunc = new double[1];
        functionValues = new ArrayList();
        coordinates = new ArrayList();
        functionHash = new HashMap();
        sampledPoints = 0;
        rectangleCounter = 1;
        indexPotentialBestRec = 0;
        minFunctionValue = 0.0;
        Double[] scaledCenter = new Double[dimensions];
        double[] realCenter = new double[dimensions];
        Double[] lTmp = new Double[dimensions];
        Double dTmp = 0.0;
        Double[] cooTmp = new Double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            scaledCenter[i] = 0.5;
            lTmp[i] = 0.5;
            dTmp = dTmp + scaledCenter[i] * scaledCenter[i];
            realCenter[i] = (double)lowerBounds[i] + scaledCenter[i] * (double)(upperBounds[i] - lowerBounds[i]);
        }
        centerPoints.add(scaledCenter);
        lengthsSide.add(lTmp);
        dTmp = Math.sqrt(dTmp);
        diagonalLength.add(dTmp);
        Point startingPoint = Point.at(realCenter);
        minFunctionValue = function.valueAt(startingPoint);
        ++sampledPoints;
        for (int i1 = 0; i1 < dimensions; ++i1) {
            cooTmp[i1] = realCenter[i1];
        }
        minimum = ValuePointColored.at(startingPoint, minFunctionValue, true);
        coordinates.add(minimum);
        SAXVSMDirectSampler.diagonalsMinFunc[0] = minFunctionValue;
        functionValues.add(minFunctionValue);
        differentDiagonalLength = diagonalLength;
        ArrayList<Integer> potentiallyOptimalRectangles = null;
        ArrayList<Double> minCVvalues = new ArrayList<Double>();
        for (iterationCounter = 0; iterationCounter < SAXVSMDirectSamplerParams.ITERATIONS_NUM; ++iterationCounter) {
            resultMinimum = SAXVSMDirectSampler.minimum(functionValues);
            params = coordinates.get((int)resultMinimum[1]).getPoint().toArray();
            consoleLogger.info("iteration: " + iterationCounter + ", minimal value " + resultMinimum[0] + " at " + (int)Math.round(params[0]) + COMMA + (int)Math.round(params[1]) + COMMA + (int)Math.round(params[2]));
            minCVvalues.add(resultMinimum[0]);
            if (SAXVSMDirectSampler.hasToBreak(minCVvalues, SAXVSMDirectSamplerParams.ITERATIONS_BREAK_THRESHOLD)) {
                consoleLogger.info("breaking iteration: " + iterationCounter + " CV error delta is less than " + SAXVSMDirectSamplerParams.ITERATIONS_BREAK_THRESHOLD + " three consequitive times.");
                break;
            }
            potentiallyOptimalRectangles = SAXVSMDirectSampler.identifyPotentiallyRec();
            for (int jj = 0; jj < potentiallyOptimalRectangles.size(); ++jj) {
                int j = potentiallyOptimalRectangles.get(jj);
                SAXVSMDirectSampler.samplePotentialRec(j);
            }
            SAXVSMDirectSampler.update();
        }
        if (iterationCounter == SAXVSMDirectSamplerParams.ITERATIONS_NUM) {
            resultMinimum = SAXVSMDirectSampler.minimum(functionValues);
            params = coordinates.get((int)resultMinimum[1]).getPoint().toArray();
            consoleLogger.info("iteration: " + iterationCounter + ", minimal value " + resultMinimum[0] + " at " + (int)Math.round(params[0]) + COMMA + (int)Math.round(params[1]) + COMMA + (int)Math.round(params[2]));
            consoleLogger.info("MAX allowed iterations num reached");
        }
        resultMinimum = SAXVSMDirectSampler.minimum(functionValues);
        StringBuffer sb = new StringBuffer();
        HashSet<String> minimalValueParameters = new HashSet<String>();
        double minimalValue = resultMinimum[0];
        sb.append("min CV error ").append(fmt.format(minimalValue)).append(" reached at ");
        int[] params2 = null;
        for (int i = 0; i < functionValues.size(); ++i) {
            if (minimalValue != functionValues.get(i)) continue;
            int[] new_params = coordinates.get(i).getPoint().toIntArray();
            if (null == params2) {
                int[] asArray;
                params2 = asArray = Arrays.copyOf(new_params, new_params.length);
                minimalValueParameters.add(Arrays.toString(asArray));
                sb.append(Arrays.toString(asArray)).append(COMMA);
                continue;
            }
            if (new_params[0] >= params2[0]) continue;
            params2 = Arrays.copyOf(new_params, new_params.length);
            sb.append(Arrays.toString(params2)).append(COMMA);
        }
        Params res = new Params((int)params2[0], (int)params2[1], (int)params2[2], SAXVSMDirectSamplerParams.SAX_NORM_THRESHOLD, strategy, minimalValue);
        consoleLogger.info(sb.append("will use ").append(res.toString()).toString());
        return res;
    }

    private static boolean hasToBreak(ArrayList<Double> minCVvalues, double threshold) {
        int size = minCVvalues.size();
        return size > 3 && threshold >= minCVvalues.get(size - 4) - minCVvalues.get(size - 3) && threshold >= minCVvalues.get(size - 3) - minCVvalues.get(size - 2) && threshold >= minCVvalues.get(size - 2) - minCVvalues.get(size - 1);
    }

    private static void update() {
        resultMinimum = SAXVSMDirectSampler.minimum(functionValues);
        minFunctionValue = resultMinimum[0];
        minimum.setBest(false);
        minimum = ValuePointColored.at(Point.at(0.0), Double.POSITIVE_INFINITY, false);
        int i = 0;
        for (ValuePointColored valuePoint : coordinates) {
            if (valuePoint.getValue() < minimum.getValue()) {
                b = i;
                minimum = valuePoint;
            }
            ++i;
        }
        minimum.setBest(true);
        coordinates.set(b, minimum);
        double epsilon = 1.0E-4;
        double e = Math.max(epsilon * Math.abs(minFunctionValue), 1.0E-8);
        double[] temporaryArray = new double[functionValues.size()];
        for (int i2 = 0; i2 < functionValues.size(); ++i2) {
            temporaryArray[i2] = (functionValues.get(i2) - minFunctionValue + e) / diagonalLength.get(i2);
        }
        indexPotentialBestRec = (int)SAXVSMDirectSampler.minimum(temporaryArray)[1];
        differentDiagonalLength = diagonalLength;
        int i1 = 0;
        while (true) {
            double diagonalTmp = differentDiagonalLength.get(i1);
            Integer[] indx = SAXVSMDirectSampler.findNonMatches(differentDiagonalLength, diagonalTmp);
            ArrayList<Double> diagonalCopy = differentDiagonalLength;
            differentDiagonalLength = new ArrayList();
            differentDiagonalLength.add(diagonalTmp);
            for (int i2 = 1; i2 < indx.length + 1; ++i2) {
                differentDiagonalLength.add(diagonalCopy.get(indx[i2 - 1]));
            }
            if (i1 + 1 == differentDiagonalLength.size()) break;
            ++i1;
        }
        Collections.sort(differentDiagonalLength);
        diagonalsMinFunc = new double[differentDiagonalLength.size()];
        for (i1 = 0; i1 < differentDiagonalLength.size(); ++i1) {
            Integer[] indx1 = SAXVSMDirectSampler.findMatches(diagonalLength, (double)differentDiagonalLength.get(i1));
            ArrayList<Double> fTmp = new ArrayList<Double>();
            for (int i2 = 0; i2 < indx1.length; ++i2) {
                fTmp.add(functionValues.get(indx1[i2]));
            }
            SAXVSMDirectSampler.diagonalsMinFunc[i1] = SAXVSMDirectSampler.minimum(fTmp)[0];
        }
    }

    private static void samplePotentialRec(int j) {
        double max_L = lengthsSide.get(j)[0];
        for (int i1 = 0; i1 < lengthsSide.get(j).length; ++i1) {
            max_L = Math.max(max_L, lengthsSide.get(j)[i1]);
        }
        Integer[] maxSideLengths = SAXVSMDirectSampler.findMatches(lengthsSide.get(j), max_L);
        double delta = 2.0 * max_L / 3.0;
        double[] w = new double[]{};
        for (int ii = 0; ii < maxSideLengths.length; ++ii) {
            int i2;
            int i22;
            Double[] c_m1 = new Double[dimensions];
            double[] x_m1 = new double[dimensions];
            Double[] c_m2 = new Double[dimensions];
            double[] x_m2 = new double[dimensions];
            double i1 = maxSideLengths[ii].intValue();
            double[] e_i = new double[dimensions];
            e_i[(int)i1] = 1.0;
            for (i22 = 0; i22 < centerPoints.get(j).length; ++i22) {
                c_m1[i22] = centerPoints.get(j)[i22] + delta * e_i[i22];
            }
            for (i22 = 0; i22 < c_m1.length; ++i22) {
                x_m1[i22] = (double)lowerBounds[i22] + c_m1[i22] * (double)(upperBounds[i22] - lowerBounds[i22]);
            }
            Point pointToSample1 = Point.at(x_m1);
            Double f_m1 = SAXVSMDirectSampler.checkCache(pointToSample1, functionHash);
            if (null == f_m1) {
                f_m1 = function.valueAt(pointToSample1);
                consoleLogger.info("@" + f_m1 + "\t" + pointToSample1.toLogString());
                SAXVSMDirectSampler.saveCache(pointToSample1, f_m1, functionHash);
            } else {
                consoleLogger.debug("** saved the computation at " + Arrays.toString(pointToSample1.toArray()));
            }
            coordinates.add(ValuePointColored.at(pointToSample1, f_m1, false));
            ++sampledPoints;
            for (i2 = 0; i2 < centerPoints.get(j).length; ++i2) {
                c_m2[i2] = centerPoints.get(j)[i2] - delta * e_i[i2];
            }
            for (i2 = 0; i2 < c_m2.length; ++i2) {
                x_m2[i2] = (double)lowerBounds[i2] + c_m2[i2] * (double)(upperBounds[i2] - lowerBounds[i2]);
            }
            Point pointToSample2 = Point.at(x_m2);
            Double f_m2 = SAXVSMDirectSampler.checkCache(pointToSample2, functionHash);
            if (null == f_m2) {
                f_m2 = function.valueAt(pointToSample2);
                consoleLogger.info("@" + f_m2 + "\t" + pointToSample2.toLogString());
                SAXVSMDirectSampler.saveCache(pointToSample2, f_m2, functionHash);
            } else {
                consoleLogger.debug("** saved the computation at " + Arrays.toString(pointToSample2.toArray()));
            }
            coordinates.add(ValuePointColored.at(pointToSample2, f_m2, false));
            ++sampledPoints;
            double[] w_pom = w;
            w = new double[ii + 1];
            System.arraycopy(w_pom, 0, w, 0, w_pom.length);
            w[ii] = Math.min(f_m2, f_m1);
            centerPoints.add(c_m1);
            centerPoints.add(c_m2);
            functionValues.add(f_m1);
            functionValues.add(f_m2);
        }
        SAXVSMDirectSampler.devideRec(w, maxSideLengths, delta, j);
    }

    private static void saveCache(Point point, Double value, HashMap<String, Double> cache) {
        StringBuffer sb = new StringBuffer();
        for (double d : point.toArray()) {
            sb.append(String.format("%d", Math.round(d))).append(" ");
        }
        cache.put(sb.toString(), value);
    }

    private static Double checkCache(Point point, HashMap<String, Double> cache) {
        StringBuffer sb = new StringBuffer();
        for (double d : point.toArray()) {
            sb.append(String.format("%d", Math.round(d))).append(" ");
        }
        return cache.get(sb.toString());
    }

    private static void devideRec(double[] w, Integer[] maxSideLengths, double delta, int j) {
        double[][] ab = SAXVSMDirectSampler.sort(w);
        for (int ii = 0; ii < maxSideLengths.length; ++ii) {
            int i1 = maxSideLengths[(int)ab[1][ii]];
            int index1 = rectangleCounter + 2 * (int)ab[1][ii];
            int index2 = rectangleCounter + 2 * (int)ab[1][ii] + 1;
            SAXVSMDirectSampler.lengthsSide.get((int)j)[i1] = delta / 2.0;
            int index = 0;
            index = index2 + 1 > index1 + 1 ? index2 + 1 : index1 + 1;
            Double[] lTmp = new Double[dimensions];
            Double[] lTmp2 = new Double[dimensions];
            for (int i2 = 0; i2 < lengthsSide.get(0).length; ++i2) {
                lTmp[i2] = lengthsSide.get(j)[i2];
                lTmp2[i2] = lengthsSide.get(j)[i2];
            }
            if (index == lengthsSide.size() + 2) {
                lengthsSide.add(lTmp);
                lengthsSide.add(lTmp2);
            } else {
                int lengthsSize = lengthsSide.size();
                for (int i2 = 0; i2 < index - lengthsSize; ++i2) {
                    Double[] lTmp3 = new Double[dimensions];
                    lengthsSide.add(lTmp3);
                }
                lengthsSide.set(index1, lTmp);
                lengthsSide.set(index2, lTmp2);
            }
            diagonalLength.set(j, 0.0);
            for (int i2 = 0; i2 < lengthsSide.get(j).length; ++i2) {
                Double dTmp = diagonalLength.get(j) + lengthsSide.get(j)[i2] * lengthsSide.get(j)[i2];
                diagonalLength.set(j, dTmp);
            }
            diagonalLength.set(j, Math.sqrt(diagonalLength.get(j)));
            Double dTmp = diagonalLength.get(j);
            Double d_kop2 = diagonalLength.get(j);
            if (index == diagonalLength.size() + 2) {
                diagonalLength.add(dTmp);
                diagonalLength.add(d_kop2);
                continue;
            }
            int size = diagonalLength.size();
            for (int i2 = 0; i2 < index - size; ++i2) {
                Double dTmp3 = 0.0;
                diagonalLength.add(dTmp3);
            }
            diagonalLength.set(index1, diagonalLength.get(j));
            diagonalLength.set(index2, diagonalLength.get(j));
        }
        rectangleCounter += 2 * maxSideLengths.length;
    }

    private static ArrayList<Integer> identifyPotentiallyRec() {
        double localPrecision = 1.0E-12;
        Integer[] sameDiagonalIdxs = SAXVSMDirectSampler.findMatches(differentDiagonalLength, (double)diagonalLength.get(indexPotentialBestRec));
        ArrayList<Integer> s_1 = new ArrayList<Integer>();
        for (int i = sameDiagonalIdxs[0].intValue(); i < differentDiagonalLength.size(); ++i) {
            Integer[] indx3 = SAXVSMDirectSampler.findMatches(functionValues, diagonalsMinFunc[i]);
            Integer[] indx4 = SAXVSMDirectSampler.findMatches(diagonalLength, (double)differentDiagonalLength.get(i));
            Integer[] idx2 = SAXVSMDirectSampler.findArrayIntersection(indx3, indx4);
            s_1.addAll(Arrays.asList(idx2));
        }
        ArrayList<Integer> s_2 = new ArrayList<Integer>();
        ArrayList<Integer> s_3 = new ArrayList<Integer>();
        if (differentDiagonalLength.size() - sameDiagonalIdxs[0] > 2) {
            double a1 = diagonalLength.get(indexPotentialBestRec);
            double a2 = differentDiagonalLength.get(differentDiagonalLength.size() - 1);
            double b1 = functionValues.get(indexPotentialBestRec);
            double b2 = diagonalsMinFunc[differentDiagonalLength.size() - 1];
            double slope = (b2 - b1) / (a2 - a1);
            double consta = b1 - slope * a1;
            for (int i1 = 0; i1 < s_1.size(); ++i1) {
                int j = (Integer)s_1.get(i1);
                if (!(functionValues.get(j) <= slope * diagonalLength.get(j) + consta + localPrecision)) continue;
                s_2.add(j);
            }
            if (0 == s_2.size()) {
                return s_1;
            }
            double[] xx = new double[s_2.size()];
            double[] yy = new double[s_2.size()];
            for (int i1 = 0; i1 < xx.length; ++i1) {
                xx[i1] = diagonalLength.get((Integer)s_2.get(i1));
                yy[i1] = functionValues.get((Integer)s_2.get(i1));
            }
            double[] h = SAXVSMDirectSampler.conhull(xx, yy);
            for (int i1 = 0; i1 < h.length; ++i1) {
                s_3.add((Integer)s_2.get((int)h[i1]));
            }
        } else {
            s_3 = s_1;
        }
        return s_3;
    }

    private static double[] conhull(double[] x, double[] y) {
        int i;
        int m = x.length;
        int start = 0;
        boolean flag = false;
        if (x.length != y.length) {
            System.out.println("Input dimension must agree");
            return null;
        }
        if (m == 2) {
            double[] h = new double[]{0.0, 1.0};
            return h;
        }
        if (m == 1) {
            double[] h = new double[]{0.0};
            return h;
        }
        int v = start;
        int w = x.length - 1;
        double[] h = new double[x.length];
        for (i = 0; i < x.length; ++i) {
            h[i] = i + 1;
        }
        while (SAXVSMDirectSampler.next(v, m) != 0 || !flag) {
            int i2;
            int c;
            int b;
            int a;
            double determinant;
            boolean leftturn;
            if (SAXVSMDirectSampler.next(v, m) == w) {
                flag = true;
            }
            if (leftturn = (determinant = x[a = v] * y[b = SAXVSMDirectSampler.next(v, m)] * 1.0 + x[b] * y[c = SAXVSMDirectSampler.next(SAXVSMDirectSampler.next(v, m), m)] * 1.0 + x[c] * y[a] * 1.0 - 1.0 * y[b] * x[c] - 1.0 * y[c] * x[a] - 1.0 * y[a] * x[b]) >= 0.0) {
                v = SAXVSMDirectSampler.next(v, m);
                continue;
            }
            int j = SAXVSMDirectSampler.next(v, m);
            int k = 0;
            double[] x1 = new double[x.length - 1];
            for (i2 = 0; i2 < x1.length; ++i2) {
                if (j == i2) {
                    ++k;
                }
                x1[i2] = x[k];
                ++k;
            }
            x = x1;
            k = 0;
            x1 = new double[y.length - 1];
            for (i2 = 0; i2 < x1.length; ++i2) {
                if (j == i2) {
                    ++k;
                }
                x1[i2] = y[k];
                ++k;
            }
            y = x1;
            k = 0;
            x1 = new double[h.length - 1];
            for (i2 = 0; i2 < x1.length; ++i2) {
                if (j == i2) {
                    ++k;
                }
                x1[i2] = h[k];
                ++k;
            }
            h = x1;
            --w;
            v = SAXVSMDirectSampler.pred(v, --m);
        }
        for (i = 0; i < h.length; ++i) {
            h[i] = h[i] - 1.0;
        }
        return h;
    }

    private static int next(int v, int m) {
        if (v + 1 == m) {
            return 0;
        }
        if (v + 1 < m) {
            return v + 1;
        }
        return -1;
    }

    private static int pred(int idx, int size) {
        if (idx + 1 == 1) {
            return size - 1;
        }
        if (idx + 1 > 1) {
            return idx - 1;
        }
        return -1;
    }

    private static double[][] sort(double[] array) {
        double[][] arr1 = new double[3][array.length];
        double[][] arr2 = new double[2][array.length];
        System.arraycopy(array, 0, arr1[0], 0, array.length);
        Arrays.sort(array);
        block0: for (int i = 0; i < array.length; ++i) {
            for (int i1 = 0; i1 < array.length; ++i1) {
                if (array[i] != arr1[0][i1] || arr1[2][i1] == 1.0) continue;
                arr1[2][i1] = 1.0;
                arr1[1][i] = i1;
                continue block0;
            }
        }
        arr2[0] = array;
        arr2[1] = arr1[1];
        return arr2;
    }

    private static double[] minimum(double[] array) {
        Double min = array[0];
        double[] res = new double[]{min, 0.0};
        for (int i = 0; i < array.length; ++i) {
            if (!(min > array[i])) continue;
            min = array[i];
            res[0] = min;
            res[1] = i;
        }
        return res;
    }

    private static double[] minimum(ArrayList<Double> array) {
        Double min = array.get(0);
        double[] res = new double[]{min, 0.0};
        for (int i = 0; i < array.size(); ++i) {
            if (!(min > array.get(i))) continue;
            min = array.get(i);
            res[0] = min;
            res[1] = i;
        }
        return res;
    }

    private static Integer[] findMatches(Double[] array, double value) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (!(Math.abs(array[i] - value) <= 1.0E-16)) continue;
            res.add(i);
        }
        return res.toArray(new Integer[res.size()]);
    }

    private static Integer[] findMatches(ArrayList<Double> array, double value) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < array.size(); ++i) {
            if (!(Math.abs(array.get(i) - value) <= 1.0E-16)) continue;
            res.add(i);
        }
        return res.toArray(new Integer[res.size()]);
    }

    private static Integer[] findNonMatches(ArrayList<Double> array, double value) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < array.size(); ++i) {
            if (!(Math.abs(array.get(i) - value) > 1.0E-16)) continue;
            res.add(i);
        }
        return res.toArray(new Integer[res.size()]);
    }

    private static Integer[] findArrayIntersection(Integer[] arr1, Integer[] arr2) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i1 = 0; i1 < arr1.length; ++i1) {
            for (int i2 = 0; i2 < arr2.length; ++i2) {
                if (arr1[i1] != arr2[i2]) continue;
                res.add(arr2[i2]);
            }
        }
        return res.toArray(new Integer[res.size()]);
    }

    protected static String toLogStr(Params params, double accuracy, double error) {
        StringBuffer sb = new StringBuffer();
        sb.append("error ").append(fmt.format(error)).append(COMMA);
        sb.append("params: strategy ").append(params.getNrStartegy().toString()).append(COMMA);
        sb.append("window ").append(params.getWindowSize()).append(COMMA);
        sb.append("PAA ").append(params.getPaaSize()).append(COMMA);
        sb.append("alphabet ").append(params.getAlphabetSize()).append(COMMA);
        sb.append("( CV error ").append(fmt.format(params.getCvError())).append(")");
        return sb.toString();
    }

    protected static String toParserString(Params params, double accuracy, double error) {
        StringBuffer sb = new StringBuffer("#");
        sb.append(SAXVSMDirectSamplerParams.TRAIN_FILE).append(COMMA);
        sb.append(fmt.format(error)).append(COMMA);
        sb.append(params.getNrStartegy().toString()).append(COMMA);
        sb.append(params.getWindowSize()).append(COMMA);
        sb.append(params.getPaaSize()).append(COMMA);
        sb.append(params.getAlphabetSize()).append(COMMA);
        sb.append(fmt.format(params.getCvError()));
        return sb.toString();
    }

    static {
        b = 0;
        dimensions = 3;
        LOGGING_LEVEL = Level.INFO;
        consoleLogger = (Logger)LoggerFactory.getLogger(SAXVSMDirectSampler.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
        minimum = ValuePointColored.at(Point.at(0.0), Double.POSITIVE_INFINITY, false);
        tp = new TextProcessor();
    }
}

