/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.direct;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import net.seninp.jmotif.direct.AbstractErrorFunction;
import net.seninp.jmotif.direct.Point;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.text.Params;
import net.seninp.jmotif.text.TextProcessor;
import net.seninp.jmotif.text.WordBag;
import net.seninp.util.StackTrace;
import org.slf4j.LoggerFactory;

public class SAXVSMCVErrorFunction
implements AbstractErrorFunction {
    public static final Character DELIMITER = Character.valueOf('~');
    private NumerosityReductionStrategy numerosityReductionStrategy;
    private double nThreshold;
    private Map<String, double[]> tsData;
    private int holdOutSampleSize;
    private TextProcessor tp = new TextProcessor();
    private static final Logger consoleLogger;
    private static final Level LOGGING_LEVEL;

    public SAXVSMCVErrorFunction(Map<String, List<double[]>> data, int holdOutSampleSize, double nThreshold, NumerosityReductionStrategy strategy) {
        this.tsData = new HashMap<String, double[]>();
        for (Map.Entry<String, List<double[]>> e : data.entrySet()) {
            String classLabel = e.getKey();
            int classCounter = 0;
            for (double[] series : e.getValue()) {
                this.tsData.put(classLabel + DELIMITER + classCounter, series);
                ++classCounter;
            }
        }
        this.holdOutSampleSize = holdOutSampleSize;
        this.nThreshold = nThreshold;
        this.numerosityReductionStrategy = strategy;
    }

    @Override
    public double valueAt(Point point) {
        double[] coords = point.toArray();
        int windowSize = Long.valueOf(Math.round(coords[0])).intValue();
        int paaSize = Long.valueOf(Math.round(coords[1])).intValue();
        int alphabetSize = Long.valueOf(Math.round(coords[2])).intValue();
        if (paaSize > windowSize) {
            return 1.0;
        }
        try {
            Params params = new Params(windowSize, paaSize, alphabetSize, this.nThreshold, this.numerosityReductionStrategy);
            consoleLogger.debug(params.toString());
            HashMap<String, WordBag> seriesBags = new HashMap<String, WordBag>();
            HashMap<String, WordBag> bags = new HashMap<String, WordBag>();
            Stack<String> samples2go = new Stack<String>();
            for (Map.Entry<String, double[]> e : this.tsData.entrySet()) {
                String seriesKey = e.getKey();
                String classLabel = seriesKey.substring(0, seriesKey.indexOf(DELIMITER.charValue()));
                double[] series = e.getValue();
                WordBag seriesBag = this.tp.seriesToWordBag(seriesKey, series, params);
                samples2go.push(seriesKey);
                seriesBags.put(seriesKey, seriesBag);
                WordBag classBag = (WordBag)bags.get(classLabel);
                if (null == classBag) {
                    classBag = new WordBag(classLabel);
                    bags.put(classLabel, classBag);
                }
                classBag.mergeWith(seriesBag);
            }
            Collections.shuffle(samples2go);
            consoleLogger.debug("series: " + seriesBags.keySet().toString());
            consoleLogger.debug("samples2go: " + samples2go.toString());
            int totalSamples = samples2go.size();
            int missclassifiedSamples = 0;
            while (!samples2go.isEmpty()) {
                consoleLogger.debug("cross valiadtion iteration, in stack " + samples2go.size() + " series");
                HashMap<String, WordBag> wordsToRemove = new HashMap<String, WordBag>();
                ArrayList<String> currentValidationSample = new ArrayList<String>();
                for (int i = 0; i < this.holdOutSampleSize && !samples2go.isEmpty(); ++i) {
                    String seriesKey = (String)samples2go.pop();
                    String classLabel = seriesKey.substring(0, seriesKey.indexOf(DELIMITER.charValue()));
                    currentValidationSample.add(seriesKey);
                    WordBag classBag = wordsToRemove.get(classLabel);
                    if (null == classBag) {
                        classBag = new WordBag(classLabel);
                        wordsToRemove.put(classLabel, classBag);
                    }
                    classBag.mergeWith((WordBag)seriesBags.get(seriesKey));
                }
                consoleLogger.debug("cross valiadtion sample: " + ((Object)currentValidationSample).toString());
                HashMap<String, WordBag> basisBags = this.adjustWordBags(bags, wordsToRemove);
                HashMap<String, HashMap<String, Double>> tfidf = this.tp.computeTFIDF(basisBags.values());
                for (String e : currentValidationSample) {
                    String trueClassLabel = e.substring(0, e.indexOf(DELIMITER.charValue()));
                    int res = this.tp.classify(trueClassLabel, (WordBag)seriesBags.get(e), tfidf);
                    if (0 != res) continue;
                    ++missclassifiedSamples;
                }
            }
            double error = Integer.valueOf(missclassifiedSamples).doubleValue() / Integer.valueOf(totalSamples).doubleValue();
            return error;
        }
        catch (Exception e) {
            System.err.println("Exception caught: " + StackTrace.toString((Throwable)e));
            return Double.MAX_VALUE;
        }
    }

    private HashMap<String, WordBag> adjustWordBags(HashMap<String, WordBag> bags, HashMap<String, WordBag> wordsToRemove) {
        HashMap<String, WordBag> res = new HashMap<String, WordBag>();
        for (Map.Entry<String, WordBag> e : bags.entrySet()) {
            res.put(e.getKey(), e.getValue().clone());
        }
        for (Map.Entry<String, WordBag> e : wordsToRemove.entrySet()) {
            String classKey = e.getKey();
            for (Map.Entry<String, AtomicInteger> eBag : e.getValue().getInternalWords().entrySet()) {
                res.get(classKey).addWord(eBag.getKey(), -eBag.getValue().intValue());
            }
        }
        return res;
    }

    static {
        LOGGING_LEVEL = Level.INFO;
        consoleLogger = (Logger)LoggerFactory.getLogger(SAXVSMCVErrorFunction.class);
        consoleLogger.setLevel(LOGGING_LEVEL);
    }
}

